struct System {
  Node::Object node;
  Node::String regionNode;

  enum class Region : uint { NTSC, PAL };

  auto region() const -> Region { return information.region; }
  auto frequency() const -> uint { return information.frequency; }

  //system.cpp
  auto run() -> void;
  auto load(Node::Object&) -> void;
  auto unload() -> void;
  auto save() -> void;
  auto power(bool reset) -> void;

  //serialization.cpp
  auto serialize(bool synchronize = true) -> serializer;
  auto unserialize(serializer&) -> bool;

private:
  struct Information {
    Region region = Region::NTSC;
    uint frequency = 93'750'000;
    uint32 serializeSize[2];
  } information;

  //serialization.cpp
  auto serialize(serializer&) -> void;
  auto serializeAll(serializer&, bool synchronize) -> void;
  auto serializeInit(bool synchronize) -> uint;
};

extern System system;

auto Region::NTSC() -> bool { return system.region() == System::Region::NTSC; }
auto Region::PAL() -> bool { return system.region() == System::Region::PAL; }
