#include "resource.hpp"

namespace Resource {
namespace GameBoy {
const unsigned char BootDMG1[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,17,4,1,33,16,128,26,205,149,0,205,150,0,19,123,254,52,32,243,17,216,0,6,8,26,19,34,35,5,32,249,
  62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,103,62,100,87,224,66,62,145,224,64,4,
  30,2,14,12,240,68,254,144,32,250,13,32,247,29,32,242,14,19,36,124,30,131,254,98,40,6,30,193,254,100,32,6,
  123,226,12,62,135,226,240,66,144,224,66,21,32,210,5,32,79,22,32,24,203,79,6,4,197,203,17,23,193,203,17,23,
  5,32,245,34,35,34,35,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,
  220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,
  33,4,1,17,168,0,26,19,190,32,254,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,254,62,1,224,80,
};
}
namespace GameBoyColor {
const unsigned char BootCGB0[2048] = {
  49,254,255,62,2,195,124,0,211,0,152,160,18,211,0,128,0,64,30,83,208,0,31,66,28,0,20,42,77,25,140,126,
  0,124,49,110,74,69,82,74,0,0,255,83,31,124,255,3,31,0,255,31,167,0,239,27,31,0,239,27,0,124,0,0,
  255,3,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,220,204,110,230,221,221,
  217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,88,67,224,112,62,252,
  224,71,205,117,2,205,0,2,38,208,205,3,2,33,0,254,14,160,175,34,13,32,252,17,4,1,33,16,128,76,26,226,
  12,205,187,3,205,188,3,19,123,254,52,32,241,17,114,0,6,8,26,19,34,35,5,32,249,205,229,3,62,1,224,79,
  62,145,224,64,33,178,152,6,78,14,68,205,134,2,175,224,79,14,128,33,66,0,6,24,242,12,190,32,254,35,5,32,
  247,33,52,1,6,25,120,134,44,5,32,251,134,32,254,205,17,3,24,2,0,0,205,208,5,175,224,112,62,17,224,80,
  33,0,128,175,34,203,108,40,251,201,42,18,19,13,32,250,201,229,33,15,255,203,134,203,70,40,252,225,201,17,0,255,
  33,3,208,14,15,62,48,18,62,32,18,26,47,161,203,55,71,62,16,18,26,47,161,176,79,126,169,230,240,71,42,169,
  161,176,50,71,121,119,62,48,18,201,62,128,224,104,224,106,14,107,42,226,5,32,251,74,9,67,14,105,42,226,5,32,
  251,201,197,213,229,33,0,216,6,1,22,63,30,64,205,74,2,225,209,193,201,62,128,224,38,224,17,62,243,224,18,224,
  37,62,119,224,36,201,205,17,2,205,98,2,121,254,56,32,20,229,175,224,79,33,167,153,62,56,34,60,254,63,32,250,
  62,1,224,79,225,197,229,33,67,1,203,126,204,137,5,225,193,205,17,2,121,214,48,210,251,2,121,254,1,202,251,2,
  125,254,209,40,33,197,6,3,14,1,22,3,126,230,248,177,34,21,32,248,12,121,254,6,32,240,17,17,0,25,5,32,
  231,17,161,255,25,193,4,120,30,131,254,98,40,6,30,193,254,100,32,7,123,224,19,62,135,224,20,250,2,208,254,0,
  40,10,61,234,2,208,121,254,1,202,134,2,13,194,134,2,201,14,38,205,63,3,205,17,2,205,98,2,13,32,244,205,
  17,2,62,1,224,79,205,51,3,205,54,3,175,224,79,205,51,3,201,33,8,0,17,81,255,14,5,205,10,2,201,197,
  213,229,33,64,216,14,32,126,230,31,254,31,40,1,60,87,42,7,7,7,230,7,71,58,7,7,7,230,24,176,254,31,
  40,1,60,15,15,15,71,230,224,178,34,120,230,3,95,126,15,15,230,31,254,31,40,1,60,7,7,179,34,13,32,199,
  225,209,193,201,14,0,26,230,240,203,73,40,2,203,55,71,35,126,176,34,26,230,15,203,73,32,2,203,55,71,35,126,
  176,34,19,203,65,40,13,213,17,248,255,203,73,40,3,17,8,0,25,209,12,121,254,24,32,204,201,71,213,22,4,88,
  203,16,23,203,19,23,21,32,246,209,34,35,34,35,201,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,
  46,15,24,243,201,62,1,224,79,205,0,2,17,7,6,33,128,128,6,48,14,4,26,34,35,34,35,19,13,32,247,5,
  32,242,17,4,1,205,132,3,1,168,255,9,205,132,3,1,248,255,9,17,114,0,14,8,35,26,34,19,13,32,249,33,
  194,152,6,8,62,8,14,16,34,13,32,252,17,16,0,25,5,32,243,175,224,79,33,194,152,62,8,34,60,254,24,32,
  2,46,226,254,40,32,3,33,2,153,254,56,32,237,33,216,8,17,64,216,6,8,62,255,18,19,18,19,14,2,205,10,
  2,62,0,18,19,18,19,19,19,5,32,234,205,98,2,33,75,1,126,254,51,32,11,46,68,30,48,42,187,32,73,28,
  24,4,46,75,30,1,42,187,32,62,46,52,1,16,0,42,128,71,13,32,250,234,0,208,33,199,6,14,0,42,184,40,
  8,12,121,254,79,32,246,24,31,121,214,65,56,28,33,22,7,22,0,95,25,250,55,1,87,126,186,40,13,17,14,0,
  25,121,131,79,214,94,56,237,14,0,33,51,7,6,0,9,126,230,31,234,6,208,234,8,208,126,230,224,7,7,7,234,
  9,208,234,11,208,205,233,4,201,17,145,7,33,0,217,250,11,208,71,14,30,203,64,32,2,19,19,26,34,32,2,27,
  27,203,72,32,2,19,19,26,34,19,19,32,2,27,27,203,80,40,5,27,43,26,34,19,26,34,19,13,32,215,33,0,
  217,17,0,218,205,100,5,201,33,18,0,250,5,208,7,7,6,0,79,9,17,64,216,6,8,229,14,2,205,10,2,19,
  19,19,19,19,19,225,5,32,240,17,66,216,14,2,205,10,2,17,74,216,14,2,205,10,2,43,43,17,68,216,14,2,
  205,10,2,201,14,96,42,229,197,33,232,7,6,0,79,9,14,8,205,10,2,193,225,13,32,236,201,250,8,208,17,24,
  0,60,61,40,3,25,32,250,201,205,29,2,120,230,255,40,15,33,228,8,6,0,42,185,40,8,4,120,254,12,32,246,
  24,45,120,234,5,208,62,30,234,2,208,17,11,0,25,86,122,230,31,95,33,8,208,58,34,123,119,122,230,224,7,7,
  7,95,33,11,208,58,34,123,119,205,233,4,205,40,5,201,205,17,2,250,67,1,203,127,40,4,224,76,24,40,62,4,
  224,76,62,1,224,108,33,0,218,205,123,5,6,16,22,0,30,8,205,74,2,33,122,0,250,0,208,71,14,2,42,184,
  204,207,3,13,32,248,201,1,15,63,126,255,255,192,0,192,240,241,3,124,252,254,254,3,7,7,15,224,224,240,240,30,
  62,126,254,15,15,31,31,255,255,0,0,1,1,1,3,255,255,225,224,192,240,249,251,31,127,248,224,243,253,62,30,224,
  240,249,127,62,124,248,224,248,240,240,248,0,0,127,127,7,15,159,191,158,31,255,255,15,30,62,60,241,251,127,127,254,
  222,223,159,31,63,62,60,248,248,0,0,3,3,7,7,255,255,193,192,243,231,247,243,192,192,192,192,31,31,30,62,63,
  31,62,62,128,0,0,0,124,31,7,0,15,255,254,0,124,248,240,0,31,15,15,0,124,248,248,0,63,62,28,0,15,
  15,15,0,124,255,255,0,0,248,248,0,7,15,15,0,129,255,255,0,243,225,128,0,224,255,127,0,252,240,192,0,62,
  124,124,0,0,0,0,0,0,136,22,54,209,219,242,60,140,146,61,92,88,201,62,112,29,89,105,25,53,168,20,170,117,
  149,153,52,111,21,255,151,75,144,23,16,57,247,246,162,73,78,67,104,224,139,240,206,12,41,232,183,134,154,82,1,157,
  113,156,189,93,109,103,63,107,179,70,40,165,198,211,39,97,24,102,106,191,13,244,66,69,70,65,65,82,66,69,75,69,
  75,32,82,45,85,82,65,82,32,73,78,65,73,76,73,67,69,32,82,124,8,18,163,162,7,135,75,32,18,101,168,22,
  169,134,177,104,160,135,102,18,161,48,60,18,133,18,100,27,7,6,111,110,110,174,175,111,178,175,178,168,171,111,175,134,
  174,162,162,18,175,19,18,161,110,175,175,173,6,76,110,175,175,18,124,172,168,106,110,19,160,45,168,43,172,100,172,109,
  135,188,96,180,19,114,124,181,174,174,124,124,101,162,108,100,133,128,176,64,136,32,104,222,0,112,222,32,120,32,32,56,
  32,176,144,32,176,160,224,176,192,152,182,72,128,224,80,30,30,88,32,184,224,136,176,16,32,0,16,32,224,24,224,24,
  0,24,224,32,168,224,32,24,224,0,32,24,216,200,24,224,0,224,64,40,40,40,24,224,96,32,24,224,0,0,8,224,
  24,48,208,208,208,32,224,232,255,127,191,50,208,0,0,0,159,99,121,66,176,21,203,4,255,127,49,110,74,69,0,0,
  255,127,239,27,0,2,0,0,255,127,31,66,242,28,0,0,255,127,148,82,74,41,0,0,255,127,255,3,47,1,0,0,
  255,127,239,3,214,1,0,0,255,127,181,66,200,61,0,0,116,126,255,3,128,1,0,0,255,103,172,119,19,26,107,45,
  214,126,255,75,117,33,0,0,255,83,95,74,82,126,0,0,255,79,210,126,76,58,224,28,237,3,255,127,95,37,0,0,
  106,3,31,2,255,3,255,127,255,127,223,1,18,1,0,0,31,35,95,3,242,0,9,0,255,127,234,3,31,1,0,0,
  159,41,26,0,12,0,0,0,255,127,127,2,31,0,0,0,255,127,224,3,6,2,32,1,255,127,235,126,31,0,0,124,
  255,127,255,63,0,126,31,0,255,127,255,3,31,0,0,0,255,3,31,0,12,0,0,0,255,127,63,3,147,1,0,0,
  0,0,0,66,127,3,255,127,255,127,140,126,0,124,0,0,255,127,239,27,128,97,0,0,255,127,0,124,224,3,31,124,
  31,0,255,3,64,65,66,32,33,34,128,129,130,16,17,18,18,176,121,184,173,22,23,7,186,5,124,19,0,0,0,0,
};
}
namespace MSX {
const unsigned char BIOS[32768] = {
  243,195,18,13,191,27,152,152,195,237,16,0,195,191,35,0,195,255,16,0,195,0,36,0,195,27,17,0,195,52,36,0,
  195,33,17,0,195,115,36,0,195,39,17,33,2,0,0,0,195,57,17,0,0,0,0,0,195,230,24,195,78,17,195,88,
  17,195,22,2,195,34,2,195,46,2,195,69,2,195,77,2,195,85,2,195,96,2,195,109,2,195,129,2,195,151,2,195,
  173,2,195,212,2,0,195,94,25,195,30,3,195,130,3,195,194,3,195,5,4,195,67,4,195,143,4,195,183,4,195,230,
  4,195,25,5,195,111,5,195,130,5,195,140,5,195,151,5,195,58,23,195,82,23,195,92,23,195,106,17,195,124,17,195,
  143,17,195,180,17,195,217,20,195,3,21,195,17,21,195,54,21,195,84,21,195,75,21,195,37,22,195,65,22,195,83,22,
  195,86,22,195,181,7,195,102,22,195,106,22,195,123,22,195,141,22,195,159,22,195,143,23,195,2,24,195,71,24,195,89,
  24,195,178,22,195,197,22,195,215,22,195,233,22,195,252,22,195,15,23,195,33,23,195,106,24,195,121,24,195,68,8,195,
  86,8,195,103,8,195,118,8,195,134,8,195,151,8,195,169,8,195,185,8,195,244,8,195,2,9,195,20,9,195,38,9,
  195,55,9,195,71,9,195,89,9,195,107,9,195,125,9,195,142,9,195,167,24,195,97,23,195,106,23,195,109,23,195,112,
  23,195,115,23,195,130,23,195,134,23,195,138,23,195,179,24,195,197,24,195,201,24,195,223,24,195,112,26,0,0,0,201,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  79,6,0,9,9,195,17,2,190,35,40,5,35,35,16,248,201,78,35,102,105,233,58,224,243,230,191,71,14,1,205,46,
  2,201,58,224,243,246,64,71,14,1,205,46,2,201,243,203,185,120,211,153,121,246,128,211,153,251,229,33,223,243,120,6,
  0,9,119,225,201,205,85,2,246,0,219,152,201,245,205,96,2,241,211,152,201,243,125,211,153,124,230,63,211,153,251,201,
  243,125,211,153,124,230,63,246,64,211,153,251,201,245,205,96,2,11,12,120,65,79,12,241,211,152,5,32,251,13,32,248,
  201,205,85,2,229,235,11,12,120,65,60,14,152,237,162,194,141,2,61,32,248,225,201,235,205,96,2,235,11,12,120,65,
  60,14,152,237,163,194,163,2,61,32,248,235,201,254,4,208,33,182,2,195,0,2,130,3,194,3,5,4,67,4,243,33,
  223,243,1,153,8,22,128,237,163,120,237,81,20,183,32,247,251,195,34,2,58,175,252,254,8,40,58,61,245,58,233,243,
  7,7,7,7,230,240,111,58,235,243,181,71,14,7,205,46,2,241,192,58,233,243,7,7,7,7,230,240,33,234,243,182,
  42,191,243,1,32,0,245,205,96,2,241,211,152,245,11,120,177,32,247,241,201,58,235,243,71,14,7,195,46,2,58,175,
  252,183,200,205,72,3,58,175,252,254,4,56,16,42,40,249,37,37,1,0,2,58,233,243,230,15,205,109,2,42,38,249,
  1,0,8,175,205,109,2,201,58,175,252,254,4,56,4,30,217,24,2,30,209,42,40,249,205,96,2,58,233,243,87,1,
  0,32,243,123,211,152,62,0,0,0,211,152,121,0,0,0,211,152,12,205,140,5,48,3,12,12,12,122,211,152,16,227,
  251,201,205,22,2,62,0,50,175,252,50,176,252,58,174,243,50,176,243,62,1,50,220,243,50,221,243,42,179,243,34,34,
  249,42,183,243,34,36,249,42,185,243,34,40,249,42,187,243,34,38,249,205,212,2,205,143,4,205,168,7,205,205,7,195,
  190,2,205,22,2,62,1,50,175,252,50,176,252,62,1,50,220,243,50,221,243,205,212,2,42,189,243,34,34,249,42,193,
  243,34,36,249,42,197,243,34,38,249,42,195,243,34,40,249,205,168,7,58,175,243,50,176,243,205,183,4,205,83,3,205,
  220,7,195,190,2,205,22,2,62,2,50,175,252,205,212,2,42,199,243,34,34,249,205,96,2,6,3,175,243,211,152,60,
  32,251,16,249,251,42,203,243,34,36,249,42,205,243,34,40,249,42,207,243,34,38,249,205,230,4,205,83,3,205,248,7,
  195,190,2,205,22,2,62,3,50,175,252,205,212,2,42,209,243,34,34,249,205,96,2,175,14,6,243,245,30,4,245,6,
  32,211,152,60,16,251,241,29,32,244,241,198,32,13,32,235,251,42,213,243,34,36,249,42,215,243,34,40,249,42,217,243,
  34,38,249,205,25,5,205,83,3,205,14,8,195,190,2,58,223,243,230,241,71,14,0,205,46,2,58,224,243,230,231,246,
  16,71,12,205,46,2,17,179,243,14,2,175,205,74,5,19,19,12,175,205,74,5,201,58,223,243,230,241,71,14,0,205,
  46,2,58,224,243,230,231,71,12,205,46,2,17,189,243,14,2,175,205,74,5,175,205,74,5,175,205,74,5,175,205,74,
  5,175,205,74,5,201,58,223,243,230,241,246,2,71,14,0,205,46,2,58,224,243,230,231,71,12,205,46,2,17,199,243,
  14,2,175,205,74,5,62,127,205,74,5,62,3,205,74,5,175,205,74,5,175,205,74,5,201,58,223,243,230,241,71,14,
  0,205,46,2,58,224,243,230,231,246,8,71,12,205,46,2,17,209,243,14,2,175,205,74,5,175,205,74,5,175,205,74,
  5,175,205,74,5,175,205,74,5,201,213,245,33,104,5,6,0,9,70,235,126,35,102,111,41,143,16,252,71,241,176,71,
  205,46,2,209,19,19,12,201,0,0,6,10,5,9,5,38,0,111,41,41,41,205,140,5,48,2,41,41,237,91,38,249,
  25,201,135,135,42,40,249,22,0,95,25,201,58,224,243,15,15,62,8,208,62,32,201,245,254,32,56,13,58,175,252,254,
  2,40,34,254,5,48,28,241,201,254,13,32,250,241,229,197,42,185,252,1,8,0,9,34,185,252,33,0,0,34,183,252,
  193,225,201,241,201,241,229,213,197,245,205,34,8,237,91,185,252,237,75,183,252,205,185,8,58,233,243,50,242,243,42,42,
  249,237,75,203,243,9,17,64,252,58,185,252,230,7,6,0,79,9,205,18,6,1,240,0,9,58,185,252,47,230,7,79,
  205,18,6,42,183,252,1,8,0,9,34,183,252,241,193,209,225,201,58,183,252,230,7,245,197,213,229,205,155,6,58,183,
  252,230,7,40,26,58,44,249,47,50,44,249,225,1,8,0,9,209,193,241,205,155,6,58,44,249,47,50,44,249,201,193,
  1,8,0,9,193,193,241,201,245,229,197,213,87,88,237,75,201,243,9,79,58,242,243,230,15,71,205,69,2,245,230,15,
  184,40,17,241,245,15,15,15,15,230,15,184,32,13,241,209,193,225,241,201,241,209,193,225,241,47,201,122,179,254,255,40,
  17,241,203,0,203,0,203,0,203,0,230,15,176,205,77,2,24,221,241,230,240,176,205,77,2,24,218,65,60,79,62,7,
  168,60,71,197,205,69,2,71,26,205,72,6,13,40,3,15,24,250,79,58,44,249,161,79,120,177,205,77,2,35,19,193,
  16,225,201,71,82,80,80,82,84,0,58,175,252,254,5,201,245,205,239,6,11,12,120,65,79,12,241,243,211,152,16,252,
  13,32,249,251,201,205,251,6,124,230,63,211,153,251,201,205,251,6,124,230,63,246,64,211,153,251,201,58,246,250,183,40,
  16,58,175,252,254,5,218,96,2,254,7,58,246,250,56,1,135,229,230,3,15,111,230,128,172,23,203,21,23,125,23,243,
  211,153,62,142,211,153,225,125,211,153,201,205,229,6,219,152,201,245,205,239,6,241,211,152,201,243,211,153,62,143,211,153,
  219,153,245,175,211,153,62,143,211,153,251,241,201,219,153,1,0,0,205,46,2,1,1,224,205,46,2,1,2,0,205,46,
  2,1,3,128,205,46,2,1,4,1,205,46,2,1,8,8,205,46,2,62,1,50,220,243,50,221,243,205,220,7,62,0,
  33,0,8,1,0,8,205,109,2,62,245,33,0,32,1,32,0,205,109,2,1,7,245,205,46,2,33,191,27,17,0,8,
  1,0,8,205,151,2,201,201,33,191,27,237,91,36,249,1,0,8,195,151,2,192,58,175,252,254,4,208,229,33,197,7,
  205,0,2,225,201,205,7,220,7,248,7,14,8,58,176,243,254,40,1,192,3,56,8,1,128,7,24,3,1,0,3,42,
  34,249,62,32,205,109,2,62,1,33,178,251,119,17,179,251,1,23,0,237,176,195,69,18,175,1,0,24,42,36,249,111,
  197,205,109,2,193,58,234,243,42,201,243,195,109,2,58,234,243,230,15,71,7,7,7,7,176,1,0,8,42,36,249,195,
  109,2,237,75,32,249,111,38,0,41,41,41,9,6,8,17,64,252,197,213,229,58,31,249,205,191,35,225,209,193,18,19,
  35,16,239,201,229,245,33,79,8,205,159,9,241,225,201,82,73,71,72,84,67,0,229,245,33,97,8,205,159,9,241,225,
  201,76,69,70,84,67,0,229,245,33,114,8,205,159,9,241,225,201,85,80,67,0,229,245,33,129,8,205,159,9,241,225,
  201,84,85,80,67,0,229,245,33,145,8,205,159,9,241,225,201,68,79,87,78,67,0,229,245,33,162,8,205,159,9,241,
  225,201,84,68,79,87,78,67,0,237,75,183,252,237,91,185,252,201,83,67,65,76,88,89,0,197,237,67,183,252,237,83,
  185,252,42,185,252,41,41,41,41,41,46,0,6,0,62,255,50,44,249,121,230,7,40,10,71,62,255,167,31,16,252,50,
  44,249,121,230,248,79,6,0,9,34,42,249,193,201,77,65,80,88,89,0,58,44,249,42,42,249,201,70,69,84,67,72,
  67,0,229,245,33,13,9,205,159,9,241,225,201,83,84,79,82,69,67,0,229,245,33,31,9,205,159,9,241,225,201,83,
  69,84,65,84,82,0,229,245,33,49,9,205,159,9,241,225,201,82,69,65,68,67,0,229,245,33,66,9,205,159,9,241,
  225,201,83,69,84,67,0,229,245,33,82,9,205,159,9,241,225,201,78,83,69,84,67,88,0,229,245,33,100,9,205,159,
  9,241,225,201,71,84,65,83,80,67,0,229,245,33,118,9,205,159,9,241,225,201,80,78,84,73,78,73,0,229,245,33,
  136,9,205,159,9,241,225,201,83,67,65,78,82,0,229,245,33,153,9,205,159,9,241,225,201,83,67,65,78,76,0,62,
  35,211,46,205,171,9,62,0,211,46,201,126,35,183,200,211,47,24,248,230,15,254,10,48,5,198,48,211,47,201,198,55,
  211,47,201,245,15,15,15,15,205,179,9,241,205,179,9,201,124,205,195,9,125,205,195,9,201,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,201,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,62,130,211,171,62,80,211,170,175,211,255,60,211,254,
  60,211,253,60,211,252,33,255,255,217,219,168,246,240,71,120,211,168,58,255,255,47,246,240,79,121,50,255,255,33,0,255,
  62,15,119,190,32,8,47,119,190,32,3,37,24,242,36,124,183,40,21,217,188,56,5,40,3,217,24,12,46,0,103,217,
  120,217,71,217,121,217,79,217,121,214,16,79,48,203,120,214,16,71,48,187,217,125,183,40,6,17,245,37,195,135,26,120,
  211,168,121,50,255,255,217,33,0,243,249,205,23,15,205,67,16,205,77,7,251,205,78,17,6,15,17,19,14,33,0,128,
  197,229,213,58,193,252,205,191,35,225,209,193,190,32,18,235,19,35,16,236,221,33,16,128,253,42,192,252,205,52,36,24,
  17,62,5,50,234,243,50,235,243,205,194,3,33,86,37,205,142,16,251,6,120,205,138,16,62,4,50,235,243,62,4,50,
  234,243,62,15,50,233,243,62,29,50,175,243,205,194,3,33,86,37,205,142,16,205,34,14,205,218,254,205,1,15,62,1,
  50,153,253,175,50,41,251,205,203,254,33,47,38,205,142,16,195,101,26,67,45,66,73,79,83,32,76,111,103,111,32,82,
  79,77,33,201,252,17,202,252,1,63,0,54,0,237,176,33,193,252,175,229,182,33,0,64,205,105,14,204,118,14,33,0,
  128,205,105,14,204,118,14,203,127,40,6,198,4,203,103,40,228,225,35,60,230,3,32,219,201,71,205,191,35,35,245,120,
  205,191,35,35,87,241,95,120,201,229,205,89,14,33,65,66,205,33,17,120,225,201,229,245,33,189,37,205,142,16,241,245,
  71,230,3,198,48,205,180,17,120,203,120,40,15,62,46,205,180,17,120,15,15,230,3,198,48,205,180,17,62,13,205,180,
  17,62,10,205,180,17,241,225,35,35,205,248,14,40,21,79,213,221,225,245,253,225,219,153,183,250,182,14,245,229,205,52,
  36,243,225,241,14,0,205,248,14,40,2,203,233,205,248,14,40,2,203,241,205,248,14,40,2,203,249,71,230,12,95,120,
  7,7,7,7,230,48,179,95,124,7,7,230,3,179,33,201,252,22,0,95,25,113,120,201,197,205,89,14,122,179,120,193,
  201,33,201,252,6,64,126,203,127,40,8,229,33,208,37,205,142,16,225,35,16,240,201,62,0,33,128,243,119,17,129,243,
  1,125,12,237,176,62,201,33,0,243,119,17,1,243,1,127,0,237,176,62,201,33,154,253,119,17,155,253,1,77,2,237,
  176,62,255,33,218,251,119,17,219,251,1,21,0,237,176,62,0,33,240,251,119,17,241,251,1,39,0,237,176,33,240,251,
  34,248,243,34,250,243,217,34,72,252,217,33,128,243,34,74,252,34,116,246,33,59,37,17,128,243,1,26,0,237,176,33,
  0,0,34,179,243,33,0,8,34,183,243,33,0,24,34,189,243,33,0,32,34,191,243,33,0,0,34,193,243,33,0,27,
  34,195,243,33,0,56,34,197,243,33,0,24,34,199,243,33,0,32,34,201,243,33,0,0,34,203,243,33,0,27,34,205,
  243,33,0,56,34,207,243,33,0,8,34,209,243,33,0,0,34,213,243,33,0,27,34,215,243,33,0,56,34,217,243,33,
  89,249,34,243,243,33,117,249,34,93,249,33,245,249,34,99,249,33,117,250,34,105,249,62,127,50,92,249,50,98,249,50,
  104,249,62,39,50,174,243,62,32,50,175,243,58,175,243,50,176,243,62,24,50,177,243,62,4,50,235,243,62,4,50,234,
  243,62,15,50,233,243,62,160,50,224,243,58,193,252,50,31,249,42,4,0,34,32,249,62,195,33,180,17,34,229,254,50,
  228,254,201,243,33,193,252,219,168,87,230,63,79,211,168,58,255,255,47,95,230,15,50,255,255,71,58,255,255,47,184,32,
  21,123,230,15,246,80,50,255,255,71,58,255,255,47,184,32,5,6,128,123,24,4,6,0,123,47,50,255,255,122,211,168,
  112,35,121,198,64,79,48,197,251,201,118,16,253,201,58,175,252,254,5,48,9,126,183,200,205,180,17,35,24,247,126,183,
  200,221,33,137,0,205,63,26,35,24,243,14,32,58,175,252,183,192,14,40,58,176,243,254,41,216,14,80,201,197,245,205,
  171,16,58,176,243,237,68,129,60,203,63,111,58,221,243,61,133,111,38,0,68,58,220,243,61,203,63,48,1,9,203,33,
  203,16,183,32,244,237,75,34,249,9,241,193,201,229,245,33,248,16,205,159,9,241,225,201,83,89,78,67,72,82,0,205,
  72,255,126,35,254,0,200,254,58,200,254,48,56,3,254,58,216,254,32,40,237,254,9,40,233,183,201,245,205,228,254,241,
  201,124,186,192,125,187,201,229,245,33,50,17,205,159,9,241,225,201,71,69,84,89,80,82,0,8,217,225,126,35,94,35,
  86,35,213,221,225,245,253,225,229,8,217,195,52,36,30,143,62,15,205,82,23,195,58,23,229,245,33,99,17,205,159,9,
  241,225,201,73,78,73,70,78,75,0,229,245,33,117,17,205,159,9,241,225,201,83,84,82,84,77,83,0,251,229,213,42,
  250,243,237,91,248,243,231,62,255,32,1,175,209,225,201,205,194,253,229,213,42,250,243,237,91,248,243,231,32,4,251,118,
  24,242,126,245,35,125,254,24,32,3,33,240,251,34,250,243,241,209,225,201,229,213,197,245,205,164,253,58,175,252,254,2,
  48,19,241,245,205,4,20,241,245,205,218,17,205,25,20,58,221,243,50,97,246,241,193,209,225,201,205,17,21,208,40,18,
  245,58,167,252,183,194,189,18,241,254,32,56,42,254,127,202,246,19,205,189,16,205,77,2,42,220,243,58,176,243,36,188,
  56,4,34,220,243,201,17,177,251,38,0,25,175,119,42,220,243,205,108,18,195,46,18,6,12,33,136,20,195,8,2,62,
  32,205,242,17,58,221,243,230,7,254,1,32,242,201,42,220,243,58,177,243,44,189,48,9,229,205,69,18,205,144,19,225,
  45,34,220,243,201,33,1,1,34,220,243,201,205,46,19,42,220,243,229,205,108,18,58,220,243,33,177,243,190,48,8,205,
  46,18,205,46,19,24,239,225,34,220,243,201,62,1,50,221,243,201,62,255,50,167,252,201,58,221,243,33,176,243,190,48,
  3,60,24,31,58,220,243,33,177,243,190,208,60,50,220,243,24,218,58,221,243,61,32,11,58,220,243,61,200,50,220,243,
  58,176,243,50,221,243,201,58,220,243,61,200,50,220,243,201,58,220,243,33,177,243,190,208,60,50,220,243,201,71,60,32,
  12,50,167,252,241,6,15,33,172,20,195,8,2,241,16,4,14,0,24,4,16,24,14,1,254,52,40,6,254,53,40,8,
  24,46,121,50,170,252,24,40,121,50,169,252,24,34,16,8,6,31,144,50,221,243,24,24,16,22,6,31,144,50,220,243,
  62,3,24,13,62,1,24,9,62,2,24,5,62,4,24,1,175,50,167,252,201,58,221,243,33,176,243,190,208,60,50,221,
  243,201,58,221,243,61,200,50,221,243,201,205,108,18,33,177,251,58,220,243,95,22,0,25,119,58,176,243,60,33,221,243,
  150,79,6,0,62,32,205,189,16,195,109,2,205,108,18,42,220,243,229,69,58,177,243,50,220,243,144,71,4,58,220,243,
  24,14,205,189,16,235,61,50,220,243,205,189,16,205,206,19,16,240,225,34,220,243,38,0,58,177,243,87,30,0,149,61,
  79,6,0,33,177,251,25,235,98,107,43,237,184,195,46,19,205,108,18,42,220,243,229,69,58,177,243,144,71,4,58,220,
  243,24,14,205,189,16,235,60,50,220,243,205,189,16,205,206,19,16,240,205,46,19,225,34,220,243,38,0,58,177,243,149,
  61,79,6,0,17,177,251,25,84,93,35,237,176,201,245,197,6,0,58,176,243,79,205,220,19,193,241,201,229,213,197,17,
  24,252,205,129,2,193,209,213,197,33,24,252,205,151,2,193,225,9,235,225,9,201,58,221,243,254,1,200,62,32,205,242,
  17,195,146,18,58,169,252,254,1,192,58,175,252,254,2,208,58,204,251,205,189,16,195,77,2,58,169,252,254,1,192,58,
  175,252,254,2,208,205,189,16,205,69,2,50,204,251,167,22,0,95,203,19,203,18,203,19,203,18,203,19,203,18,175,33,
  175,252,190,32,5,42,183,243,24,3,42,193,243,229,25,17,24,252,1,8,0,205,129,2,58,170,252,254,0,32,7,33,
  24,252,6,8,24,5,33,30,252,6,2,126,47,119,35,16,250,225,17,248,7,25,235,33,24,252,1,8,0,205,151,2,
  205,189,16,62,255,195,77,2,7,86,22,8,146,18,9,31,18,10,46,18,11,69,18,12,182,7,13,108,18,27,114,18,
  28,120,18,29,146,18,30,167,18,31,176,18,106,182,7,69,182,7,75,46,19,74,76,18,108,43,19,76,76,19,77,144,
  19,89,12,19,65,167,18,66,176,18,67,21,19,68,34,19,72,69,18,120,4,19,121,8,19,205,182,255,245,205,37,22,
  56,8,205,3,21,40,246,241,24,12,62,13,205,246,20,175,50,21,244,241,55,201,245,211,145,62,0,211,144,47,211,144,
  241,167,201,205,187,255,219,144,31,31,62,255,48,1,47,167,201,229,245,33,166,252,175,190,119,32,8,241,254,1,32,19,
  119,24,17,241,254,64,56,9,254,96,48,5,214,64,191,24,2,254,80,55,225,201,205,219,253,58,170,246,167,202,84,21,
  62,1,50,221,243,195,84,21,63,32,0,205,224,253,33,72,21,205,142,16,42,221,243,34,202,251,17,176,251,38,0,125,
  25,119,205,143,17,254,127,202,228,21,254,32,48,17,6,20,33,229,21,205,0,2,175,50,168,252,50,170,252,24,227,245,
  58,168,252,167,196,139,21,241,223,24,201,205,4,20,42,220,243,34,188,246,62,32,50,167,246,205,189,16,205,69,2,254,
  32,32,40,42,220,243,58,176,243,188,32,29,38,0,17,177,251,25,126,183,40,19,58,167,246,205,189,16,205,77,2,42,
  188,246,34,220,243,201,195,25,20,62,32,245,58,167,246,223,241,50,167,246,24,195,201,55,225,201,201,201,201,201,175,225,
  201,201,201,201,201,24,0,24,0,214,21,215,21,24,0,218,21,219,21,24,0,220,21,24,0,24,0,24,0,24,0,221,
  21,222,21,24,0,24,0,24,0,225,21,24,0,24,0,226,21,24,0,24,0,24,0,24,0,24,0,227,21,24,0,24,
  0,24,0,24,0,219,170,230,240,246,7,211,170,219,169,230,16,192,219,170,230,240,246,6,211,170,219,169,230,2,192,55,
  201,229,245,33,76,22,205,159,9,241,225,201,73,83,67,78,84,67,0,195,65,22,229,245,33,97,22,205,159,9,241,225,
  201,66,69,69,80,0,34,220,243,201,229,245,33,117,22,205,159,9,241,225,201,70,78,75,83,66,0,229,245,33,134,22,
  205,159,9,241,225,201,69,82,65,70,78,75,0,229,245,33,152,22,205,159,9,241,225,201,68,83,80,70,78,75,0,58,
  175,252,254,2,216,58,176,252,205,189,253,183,202,130,3,195,194,3,229,245,33,190,22,205,159,9,241,225,55,201,84,65,
  80,73,79,78,0,229,245,33,209,22,205,159,9,241,225,55,201,84,65,80,73,78,0,229,245,33,226,22,205,159,9,241,
  225,201,84,65,80,73,79,70,0,229,245,33,245,22,205,159,9,241,225,55,201,84,65,80,79,79,78,0,229,245,33,8,
  23,205,159,9,241,225,55,201,84,65,80,79,85,84,0,229,245,33,26,23,205,159,9,241,225,201,84,65,80,79,79,70,
  0,197,71,219,170,4,40,12,203,231,5,40,9,203,167,5,40,4,193,201,238,16,211,170,193,201,30,0,62,8,205,82,
  23,60,205,82,23,60,205,82,23,60,30,184,62,7,205,82,23,201,243,211,160,245,123,211,161,251,241,201,211,160,219,162,
  201,183,62,14,40,1,60,211,171,201,219,168,201,211,168,201,219,153,201,243,197,79,219,170,230,240,177,211,170,219,169,193,
  251,201,205,167,255,201,205,172,255,201,58,100,248,167,201,197,254,0,32,25,62,8,205,115,23,15,15,15,15,47,230,15,
  229,33,242,23,22,0,95,25,126,225,193,167,201,229,213,30,0,61,40,2,203,243,62,15,243,205,92,23,251,230,191,179,
  95,62,15,205,82,23,62,14,243,205,92,23,251,47,230,15,33,226,23,6,0,79,9,126,209,225,193,167,201,62,0,193,
  167,201,0,1,5,0,7,8,6,7,3,2,4,3,0,1,5,0,0,7,1,8,5,6,0,7,3,0,2,1,4,5,
  3,0,254,5,48,3,183,32,9,62,8,205,115,23,246,254,60,201,243,61,213,30,3,71,230,1,40,2,30,76,62,15,
  205,92,23,230,191,179,95,62,15,205,82,23,120,6,16,230,2,40,2,6,32,62,14,243,205,92,23,251,209,160,40,2,
  24,3,62,255,201,175,201,229,245,33,83,24,205,159,9,241,225,175,201,71,84,80,65,68,0,229,245,33,100,24,205,159,
  9,241,225,201,71,84,80,68,76,0,205,154,24,70,4,35,126,144,35,35,166,111,38,0,201,205,154,24,126,60,71,35,
  150,200,120,35,35,229,166,43,43,43,119,225,35,126,35,102,111,5,72,6,0,9,115,246,1,201,42,243,243,71,7,7,
  128,128,79,6,0,9,201,183,219,170,203,183,32,2,203,247,211,170,201,229,245,33,190,24,205,159,9,241,225,201,79,85,
  84,68,76,80,0,46,2,24,3,58,56,251,213,22,0,93,33,65,251,25,30,37,183,40,4,25,61,24,249,209,201,42,
  250,243,34,248,243,201,229,213,197,245,217,8,229,213,197,245,253,229,221,229,205,154,253,219,153,183,50,231,243,242,78,25,
  205,159,253,42,158,252,35,34,158,252,175,50,217,251,58,246,243,61,50,246,243,32,55,62,3,50,246,243,175,205,2,24,
  47,230,1,50,232,243,205,99,25,42,248,243,237,91,250,243,231,32,27,58,247,243,61,50,247,243,32,18,33,218,251,1,
  255,11,113,35,16,252,205,99,25,62,1,50,247,243,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,205,214,
  253,237,69,219,170,230,240,79,6,11,33,229,251,121,211,170,219,169,119,35,12,16,246,221,33,218,251,17,229,251,58,235,
  251,15,33,190,38,56,3,33,238,38,14,11,26,221,190,0,196,180,25,47,221,166,0,8,26,221,119,0,8,6,8,15,
  56,26,35,16,250,221,35,19,13,200,121,254,5,32,221,33,222,39,24,216,245,62,5,50,247,243,241,201,245,121,254,5,
  40,7,254,4,40,28,195,19,26,120,254,3,32,4,62,0,24,33,254,2,32,4,62,1,24,25,254,1,32,53,62,2,
  24,17,120,254,8,32,4,62,3,24,8,254,7,32,36,62,4,24,0,229,197,213,7,7,7,7,33,127,248,22,0,95,
  25,235,26,167,40,8,213,205,32,26,209,19,24,244,209,193,225,24,9,126,167,40,5,229,205,32,26,225,241,195,162,25,
  42,248,243,119,35,125,254,24,32,3,33,240,251,213,237,91,250,243,231,209,200,34,248,243,201,205,63,26,221,225,201,8,
  217,245,197,213,229,237,87,245,217,253,229,58,248,250,245,253,225,8,205,52,36,253,225,8,217,241,226,94,26,251,225,209,
  193,241,217,8,201,24,254,205,218,254,17,34,38,195,135,26,229,245,33,128,26,205,159,9,241,225,17,7,38,195,135,26,
  67,65,76,66,65,83,0,219,153,33,6,40,6,12,14,153,237,179,1,0,8,175,211,152,11,120,177,32,248,33,191,27,
  1,0,8,126,211,152,35,11,120,177,32,247,62,0,211,153,62,64,211,153,33,238,37,126,211,152,35,126,167,32,249,26,
  211,152,19,26,167,32,249,195,101,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,60,66,165,165,195,189,66,60,60,126,219,219,189,195,126,60,108,170,146,68,68,40,16,0,16,
  40,68,130,68,40,16,0,16,56,56,214,254,214,56,0,16,56,124,124,254,214,56,0,0,0,0,24,24,0,0,0,255,
  255,255,231,231,255,255,255,60,66,129,129,129,129,66,60,195,189,126,126,126,126,189,195,12,4,8,112,136,136,112,0,0,
  112,136,136,112,32,112,32,32,48,40,40,32,224,192,0,56,60,36,36,228,220,24,0,16,68,56,170,56,68,16,0,16,
  16,16,56,16,16,16,16,16,16,16,239,0,0,0,0,0,0,0,239,16,16,16,16,16,16,16,224,16,16,16,16,16,
  16,16,15,16,16,16,16,16,16,16,239,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,255,0,0,0,0,0,
  0,0,15,16,16,16,16,0,0,0,224,16,16,16,16,16,16,16,15,0,0,0,0,16,16,16,224,0,0,0,0,129,
  66,36,24,24,36,66,129,1,2,4,8,16,32,64,128,128,64,32,16,8,4,2,1,0,0,16,255,16,0,0,0,0,
  0,0,0,0,0,0,0,32,32,32,32,0,32,0,0,80,80,0,0,0,0,0,0,0,80,248,80,248,80,0,0,32,
  112,160,112,40,112,32,0,0,200,208,32,88,152,0,0,96,144,96,168,152,96,0,0,64,64,0,0,0,0,0,0,32,
  64,64,64,64,32,0,0,32,16,16,16,16,32,0,0,0,32,168,112,80,136,0,0,0,32,32,248,32,32,0,0,0,
  0,0,0,0,64,64,0,0,0,0,248,0,0,0,0,0,0,0,0,0,64,0,0,0,8,16,32,64,128,0,0,112,
  136,168,168,136,112,0,0,32,96,32,32,32,112,0,0,112,136,8,112,128,248,0,0,248,8,48,8,136,112,0,0,16,
  48,80,248,16,16,0,0,248,128,112,8,136,112,0,0,48,64,112,136,136,112,0,0,248,136,16,32,32,32,0,0,112,
  136,112,136,136,112,0,0,112,136,136,120,8,112,0,0,0,0,64,0,0,64,0,0,0,0,64,0,0,64,64,0,0,
  24,96,128,96,24,0,0,0,0,248,0,248,0,0,0,0,192,48,8,48,192,0,0,112,136,48,32,0,32,0,0,112,
  136,152,168,168,152,64,0,112,136,136,248,136,136,0,0,224,144,224,144,136,240,0,0,112,136,128,128,136,112,0,0,240,
  72,72,72,72,240,0,0,248,128,224,128,128,248,0,0,248,128,128,224,128,128,0,0,112,136,128,184,136,112,0,0,136,
  136,248,136,136,136,0,0,112,32,32,32,32,112,0,0,56,8,8,8,136,112,0,0,136,144,160,224,144,136,0,0,128,
  128,128,128,128,248,0,0,216,168,168,136,136,136,0,0,200,168,168,152,152,136,0,0,112,136,136,136,136,112,0,0,240,
  136,136,240,128,128,0,0,112,136,136,168,144,104,0,0,240,136,136,240,160,152,0,0,112,128,112,8,8,240,0,0,248,
  32,32,32,32,32,0,0,136,136,136,136,136,120,0,0,136,136,136,80,80,32,0,0,136,136,168,168,168,216,0,0,136,
  80,32,80,136,136,0,0,136,136,112,32,32,32,0,0,248,16,32,64,128,248,0,0,112,64,64,64,64,112,0,0,0,
  128,64,32,16,8,0,0,112,16,16,16,16,112,0,0,64,160,0,0,0,0,0,0,0,0,0,0,0,0,248,0,32,
  16,0,0,0,0,0,0,0,0,120,136,152,104,0,0,128,128,240,136,136,240,0,0,0,0,120,128,128,120,0,0,8,
  8,120,136,136,120,0,0,0,0,112,152,224,120,0,0,48,72,64,64,224,64,64,64,0,0,120,136,136,120,8,112,128,
  128,240,136,136,136,0,0,32,0,96,32,32,112,0,0,16,0,48,16,16,16,16,96,128,128,152,160,224,152,0,0,192,
  64,64,64,64,112,0,0,0,0,240,168,168,168,0,0,0,0,240,136,136,136,0,0,0,0,112,136,136,112,0,0,0,
  0,240,136,136,240,128,128,0,0,120,136,136,120,8,8,0,0,184,192,128,128,0,0,0,0,120,240,8,240,0,0,64,
  64,240,64,72,48,0,0,0,0,136,136,136,120,0,0,0,0,136,136,80,32,0,0,0,0,136,168,168,216,0,0,0,
  0,200,48,96,152,0,0,0,0,136,136,136,120,8,112,0,0,248,48,64,248,0,0,16,32,32,64,32,32,16,0,32,
  32,32,32,32,32,32,0,64,32,32,16,32,32,64,0,80,160,0,0,0,0,0,0,0,32,80,80,248,0,0,0,112,
  136,128,128,136,112,32,64,80,0,136,136,136,120,0,0,8,16,112,152,224,120,0,0,32,80,120,136,152,104,0,0,80,
  0,120,136,152,104,0,0,64,32,120,136,152,104,0,0,32,0,120,136,152,104,0,0,0,0,120,128,128,120,32,64,32,
  80,112,152,224,120,0,0,80,0,112,152,224,120,0,0,64,32,112,152,224,120,0,0,80,0,96,32,32,112,0,0,32,
  80,96,32,32,112,0,0,64,32,96,32,32,112,0,0,80,112,136,136,248,136,0,0,32,112,136,136,248,136,0,0,24,
  248,128,224,128,248,0,0,0,0,208,104,176,216,0,0,120,160,176,224,160,184,0,0,32,80,112,136,136,112,0,0,80,
  0,112,136,136,112,0,0,64,32,112,136,136,112,0,0,32,80,136,136,136,120,0,0,64,32,136,136,136,120,0,0,80,
  0,136,136,136,120,8,112,80,112,136,136,136,112,0,0,80,136,136,136,136,112,0,0,32,32,120,128,128,120,32,32,32,
  80,64,224,64,72,176,0,136,136,80,248,32,112,32,0,128,208,176,176,184,208,136,128,56,64,240,64,240,64,56,0,8,
  16,120,136,152,104,0,0,16,32,96,32,32,112,0,0,16,32,112,136,136,112,0,0,16,32,136,136,136,120,0,0,40,
  80,240,136,136,136,0,0,40,208,168,168,152,136,0,0,0,0,120,136,152,104,0,112,0,0,112,136,136,112,0,112,32,
  0,32,96,136,112,0,0,0,0,0,224,128,0,0,0,0,0,0,224,32,0,0,0,64,72,80,48,72,144,56,0,64,
  72,80,40,88,184,8,0,32,0,32,32,32,32,0,0,0,0,0,72,144,72,0,0,0,0,0,144,72,144,0,0,40,
  80,112,136,248,136,0,0,40,80,120,136,152,104,0,0,40,80,112,32,32,112,0,0,40,80,96,32,32,112,0,0,40,
  112,136,136,136,112,0,0,40,80,112,136,136,112,0,0,40,80,136,136,136,120,0,0,40,80,0,136,136,120,0,0,252,
  72,72,72,72,232,8,48,72,0,216,72,72,232,8,48,224,104,48,232,88,184,8,0,80,40,0,0,0,0,0,0,0,
  32,80,136,80,32,0,0,0,72,80,32,104,168,0,0,124,168,168,168,104,40,40,68,112,128,112,136,112,8,136,112,0,
  0,0,0,0,0,255,255,240,240,240,240,15,15,15,15,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,
  0,0,60,60,0,0,0,255,255,255,255,255,255,0,0,192,192,192,192,192,192,192,192,15,15,15,15,240,240,240,240,252,
  252,252,252,252,252,252,252,3,3,3,3,3,3,3,3,63,63,63,63,63,63,63,63,17,34,68,136,17,34,68,136,136,
  68,34,17,136,68,34,17,254,124,56,16,0,0,0,0,0,0,0,0,16,56,124,254,128,192,224,240,224,192,128,0,1,
  3,7,15,7,3,1,0,255,126,60,24,24,60,126,255,129,195,231,255,255,231,195,129,240,240,240,240,0,0,0,0,0,
  0,0,0,15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,0,240,240,240,240,51,51,204,204,51,51,204,204,0,
  16,40,40,124,0,0,0,16,16,56,16,56,16,16,0,0,0,80,136,168,80,0,0,255,255,255,255,255,255,255,255,0,
  0,0,0,255,255,255,255,240,240,240,240,240,240,240,240,15,15,15,15,15,15,15,15,255,255,255,255,0,0,0,0,0,
  0,104,144,144,104,0,0,96,144,224,144,144,224,128,0,248,136,128,128,128,128,0,0,248,80,80,80,80,72,128,0,248,
  72,32,64,136,248,0,0,0,0,120,144,136,112,0,0,0,0,136,136,200,176,128,128,0,0,80,80,32,80,80,32,112,
  32,112,168,168,112,32,112,112,136,248,136,136,112,0,0,112,136,136,136,80,216,0,0,48,64,48,72,72,48,0,0,0,
  0,80,168,168,80,0,0,0,16,112,168,168,112,64,0,0,112,128,224,128,112,0,0,112,136,136,136,136,136,0,0,0,
  248,0,248,0,248,0,0,0,32,32,248,32,32,248,0,0,192,48,8,48,192,248,0,0,24,96,128,96,24,248,0,0,
  24,32,32,32,32,32,32,32,32,32,32,32,32,192,0,0,32,0,248,0,32,0,0,0,104,176,0,104,176,0,0,0,
  48,72,72,48,0,0,0,0,48,120,120,48,0,0,0,0,0,0,0,48,0,0,0,28,16,16,144,80,48,16,0,224,
  144,144,0,0,0,0,0,96,16,96,240,0,0,0,0,0,112,112,112,112,112,112,0,170,85,170,85,170,85,170,85,197,
  229,245,87,167,243,252,222,36,241,225,229,213,229,245,124,7,7,230,3,111,71,62,252,205,248,35,95,69,241,230,3,205,
  248,35,71,219,168,87,163,176,225,205,128,243,123,209,245,203,122,196,26,37,241,225,193,201,4,5,200,7,7,16,252,201,
  229,87,213,167,243,252,222,36,193,225,213,229,124,7,7,230,3,111,71,62,252,205,248,35,95,69,122,230,3,205,248,35,
  71,219,168,87,163,176,225,89,205,133,243,209,229,203,122,196,26,37,225,201,8,217,243,253,229,241,221,229,225,87,167,252,
  222,36,213,122,230,3,71,14,252,221,229,241,7,7,230,3,135,40,7,203,0,203,1,61,32,249,33,103,36,229,219,168,
  245,161,176,217,195,140,243,8,217,243,209,203,122,196,26,37,8,217,201,243,229,111,230,3,71,62,171,198,85,5,242,123,
  36,87,124,7,7,230,3,103,71,62,192,7,7,5,242,139,36,95,47,79,122,163,71,125,167,242,214,36,15,15,230,3,
  229,197,71,62,171,198,85,5,242,165,36,163,71,122,230,192,103,219,168,111,230,192,180,211,168,58,255,255,47,161,176,79,
  50,255,255,125,211,168,33,197,252,122,230,3,133,111,124,206,0,103,121,119,193,225,219,168,161,176,211,168,225,201,87,15,
  15,95,230,192,111,219,168,79,230,63,181,211,168,123,230,3,111,124,38,3,24,2,41,41,214,64,48,250,124,47,103,58,
  255,255,47,95,164,181,50,255,255,111,121,211,168,122,230,3,79,6,0,125,33,197,252,9,119,201,122,15,15,230,192,71,
  219,168,79,230,63,176,211,168,123,50,255,255,121,211,168,122,230,3,79,6,0,33,197,252,9,115,201,211,168,94,24,3,
  211,168,115,122,211,168,201,211,168,8,205,152,243,8,241,211,168,8,201,221,233,0,67,45,66,73,79,83,32,48,46,50,
  57,32,32,32,32,32,32,99,98,105,111,115,46,115,102,46,110,101,116,13,10,67,104,97,114,97,99,116,101,114,32,115,
  101,116,58,32,85,83,13,10,73,110,116,101,114,114,117,112,116,32,102,114,101,113,117,101,110,99,121,58,32,54,48,72,
  122,13,10,75,101,121,98,111,97,114,100,32,116,121,112,101,58,32,85,83,13,10,13,10,13,10,13,10,0,73,110,105,
  116,32,82,79,77,32,105,110,32,115,108,111,116,58,32,0,67,97,110,110,111,116,32,101,120,101,99,117,116,101,32,97,
  32,66,65,83,73,67,32,82,79,77,46,13,10,0,69,82,82,79,82,58,0,77,69,77,79,82,89,32,78,79,84,32,
  70,79,85,78,68,46,0,67,65,76,76,69,68,32,78,79,78,32,69,88,73,83,84,73,78,71,32,66,65,83,73,67,
  46,0,83,84,65,67,75,32,69,82,82,79,82,46,0,13,10,13,10,78,111,32,99,97,114,116,114,105,100,103,101,32,
  102,111,117,110,100,46,13,10,13,10,84,104,105,115,32,118,101,114,115,105,111,110,32,111,102,32,67,45,66,73,79,83,
  32,99,97,110,13,10,111,110,108,121,32,115,116,97,114,116,32,99,97,114,116,114,105,100,103,101,115,46,13,10,80,108,
  101,97,115,101,32,114,101,115,116,97,114,116,32,121,111,117,114,32,77,83,88,13,10,40,101,109,117,108,97,116,111,114,
  41,32,119,105,116,104,32,97,32,99,97,114,116,114,105,100,103,101,13,10,105,110,115,101,114,116,101,100,46,0,48,49,
  50,51,52,53,54,55,56,57,45,61,92,91,93,59,39,96,44,46,47,0,97,98,99,100,101,102,103,104,105,106,107,108,
  109,110,111,112,113,114,115,116,117,118,119,120,121,122,41,33,64,35,36,37,94,38,42,40,95,43,124,123,125,58,34,126,
  60,62,63,0,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,9,172,
  171,186,239,189,244,251,236,7,23,241,30,1,13,6,5,187,243,242,29,0,196,17,188,199,205,20,21,19,220,198,221,200,
  11,27,194,219,204,24,210,18,192,26,207,28,25,15,10,0,253,252,0,0,245,0,0,8,31,240,22,2,14,4,3,247,
  174,175,246,0,254,0,250,193,206,212,16,214,223,202,222,201,12,211,195,215,203,169,209,0,197,213,208,249,170,248,235,159,
  217,191,155,152,224,225,231,135,238,233,0,237,218,183,185,229,134,166,167,0,132,151,141,139,140,148,129,177,161,145,179,181,
  230,164,162,163,131,147,137,150,130,149,136,138,160,133,216,173,158,190,156,157,0,0,226,128,0,0,0,232,234,182,184,228,
  143,0,168,0,142,0,0,0,0,153,154,176,0,146,178,180,0,165,0,227,0,0,0,0,144,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,27,9,0,8,0,13,32,12,0,0,29,30,31,28,42,43,47,48,49,50,51,52,53,54,
  55,56,57,45,44,46,0,128,112,129,0,130,1,132,245,135,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,229,193,27,123,178,40,3,9,24,248,193,201,
  229,245,33,181,49,205,159,9,62,32,211,46,122,211,47,123,211,47,241,225,201,82,79,77,66,65,83,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,229,245,
  33,73,58,205,159,9,241,225,201,66,65,83,73,67,32,115,116,97,116,101,109,101,110,116,115,32,97,114,101,32,110,111,
  116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,142,16,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,34,125,205,159,9,241,
  225,201,117,110,107,110,111,119,110,64,55,68,49,55,0,57,125,221,33,137,1,205,63,26,201,221,33,133,1,195,63,26,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,31,126,205,159,9,241,225,201,117,
  110,107,110,111,119,110,64,55,69,49,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
}
namespace MSX2 {
const unsigned char BIOS[32768] = {
  243,195,18,13,191,27,152,152,195,146,17,0,195,210,35,0,195,164,17,0,195,19,36,0,195,192,17,0,195,71,36,0,
  195,198,17,0,195,134,36,0,195,204,17,33,2,1,0,0,195,222,17,0,0,0,0,0,195,154,25,195,243,17,195,253,
  17,195,22,2,195,34,2,195,46,2,195,81,2,195,87,2,195,95,2,195,113,2,195,133,2,195,164,2,195,195,2,195,
  226,2,195,235,2,0,195,18,26,195,53,3,195,148,3,195,157,3,195,166,3,195,175,3,195,184,3,195,16,4,195,63,
  4,195,114,4,195,200,4,195,219,4,195,229,4,195,240,4,195,238,23,195,6,24,195,16,24,195,15,18,195,33,18,195,
  52,18,195,89,18,195,141,21,195,183,21,195,197,21,195,234,21,195,8,22,195,255,21,195,217,22,195,245,22,195,7,23,
  195,10,23,195,41,7,195,26,23,195,30,23,195,47,23,195,65,23,195,83,23,195,67,24,195,182,24,195,251,24,195,13,
  25,195,102,23,195,121,23,195,139,23,195,157,23,195,176,23,195,195,23,195,213,23,195,30,25,195,45,25,195,80,8,195,
  98,8,195,115,8,195,130,8,195,146,8,195,163,8,195,181,8,195,197,8,195,0,9,195,14,9,195,32,9,195,50,9,
  195,67,9,195,83,9,195,101,9,195,119,9,195,137,9,195,154,9,195,91,25,195,21,24,195,30,24,195,33,24,195,36,
  24,195,39,24,195,54,24,195,58,24,195,62,24,195,103,25,195,121,25,195,125,25,195,147,25,195,36,27,195,237,26,195,
  243,26,195,222,16,195,44,6,195,59,27,195,50,6,195,71,6,195,81,6,195,141,6,195,147,6,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  79,6,0,9,9,195,17,2,190,35,40,5,35,35,16,248,201,78,35,102,105,233,58,224,243,230,191,71,14,1,205,46,
  2,201,58,224,243,246,64,71,14,1,205,46,2,201,243,203,185,120,211,153,121,246,128,211,153,251,229,33,223,243,121,254,
  8,56,7,254,24,48,8,33,223,255,120,6,0,9,119,225,201,205,95,2,219,152,201,245,205,113,2,241,211,152,201,243,
  175,211,153,62,142,211,153,125,211,153,124,230,63,211,153,251,201,243,175,211,153,62,142,211,153,125,211,153,124,230,63,246,
  64,211,153,251,201,245,58,175,252,254,5,48,5,205,113,2,24,3,205,81,6,11,12,120,65,79,12,241,211,152,16,252,
  13,32,249,201,58,175,252,254,4,48,5,205,95,2,24,3,205,71,6,229,235,11,12,120,65,60,14,152,237,178,61,32,
  251,225,201,235,58,175,252,254,4,48,5,205,113,2,24,3,205,81,6,235,11,12,120,65,60,14,152,237,179,61,32,251,
  235,201,221,229,221,33,209,0,195,237,26,58,175,252,254,8,40,58,61,245,58,233,243,7,7,7,7,230,240,111,58,235,
  243,181,71,14,7,205,46,2,241,192,58,233,243,7,7,7,7,230,240,33,234,243,182,42,191,243,1,32,0,245,205,113,
  2,241,211,152,245,11,120,177,32,247,241,201,58,235,243,71,14,7,195,46,2,58,175,252,183,200,205,95,3,58,175,252,
  254,4,56,16,42,40,249,37,37,1,0,2,58,233,243,230,15,205,50,6,42,38,249,1,0,8,175,205,50,6,201,58,
  175,252,254,4,56,4,30,217,24,2,30,209,42,40,249,205,81,6,58,233,243,87,1,0,32,243,123,211,152,62,0,211,
  152,121,211,152,12,205,229,4,48,3,12,12,12,122,211,152,16,232,251,201,221,229,221,33,213,0,195,237,26,221,229,221,
  33,217,0,195,237,26,221,229,221,33,221,0,195,237,26,221,229,221,33,225,0,195,237,26,58,176,243,254,41,48,40,58,
  223,243,230,241,71,14,0,205,46,2,58,224,243,230,231,246,16,71,12,205,46,2,17,179,243,14,2,175,205,163,4,19,
  19,12,175,205,163,4,201,58,223,243,230,241,246,4,71,14,0,205,46,2,58,224,243,230,231,246,16,71,12,205,46,2,
  17,34,249,14,2,62,3,205,163,4,12,175,205,163,4,201,58,223,243,230,241,71,14,0,205,46,2,58,224,243,230,231,
  71,12,205,46,2,17,189,243,14,2,175,205,163,4,175,205,163,4,175,205,163,4,175,205,163,4,175,205,163,4,201,58,
  223,243,230,241,246,2,71,14,0,205,46,2,58,224,243,230,231,71,12,205,46,2,17,199,243,14,2,175,205,163,4,62,
  127,205,163,4,62,3,205,163,4,175,205,163,4,175,205,163,4,201,58,223,243,230,241,71,14,0,205,46,2,58,224,243,
  230,231,246,8,71,12,205,46,2,17,209,243,14,2,175,205,163,4,175,205,163,4,175,205,163,4,175,205,163,4,175,205,
  163,4,201,213,245,33,193,4,6,0,9,70,235,126,35,102,111,41,143,16,252,71,241,176,71,205,46,2,209,19,19,12,
  201,0,0,6,10,5,9,5,38,0,111,41,41,41,205,229,4,48,2,41,41,237,91,38,249,25,201,135,135,42,40,249,
  22,0,95,25,201,58,224,243,15,15,62,8,208,62,32,201,245,254,32,56,13,58,175,252,254,2,40,43,254,5,48,28,
  241,201,254,13,32,250,241,229,197,42,185,252,1,8,0,9,34,185,252,33,0,0,34,183,252,193,225,201,241,221,229,221,
  33,137,0,195,237,26,201,241,229,213,197,245,205,46,8,237,91,185,252,237,75,183,252,205,197,8,58,233,243,50,242,243,
  42,42,249,237,75,203,243,9,17,64,252,58,185,252,230,7,6,0,79,9,205,116,5,1,240,0,9,58,185,252,47,230,
  7,79,205,116,5,42,183,252,1,8,0,9,34,183,252,241,193,209,225,201,58,183,252,230,7,245,197,213,229,205,253,5,
  58,183,252,230,7,40,26,58,44,249,47,50,44,249,225,1,8,0,9,209,193,241,205,253,5,58,44,249,47,50,44,249,
  201,193,1,8,0,9,193,193,241,201,245,229,197,213,87,88,237,75,201,243,9,79,58,242,243,230,15,71,205,81,2,245,
  230,15,184,40,17,241,245,15,15,15,15,230,15,184,32,13,241,209,193,225,241,201,241,209,193,225,241,47,201,122,179,254,
  255,40,17,241,203,0,203,0,203,0,203,0,230,15,176,205,87,2,24,221,241,230,240,176,205,87,2,24,218,65,60,79,
  62,7,168,60,71,197,205,81,2,71,26,205,170,5,13,40,3,15,24,250,79,58,44,249,161,79,120,177,205,87,2,35,
  19,193,16,225,201,71,82,80,80,82,84,0,58,175,252,254,5,201,245,205,81,6,11,12,120,65,79,12,241,243,211,152,
  16,252,13,32,249,251,201,205,93,6,124,230,63,211,153,251,201,205,93,6,124,230,63,246,64,211,153,251,201,58,246,250,
  183,40,16,58,175,252,254,5,218,113,2,254,7,58,246,250,56,1,135,229,230,3,15,111,230,128,172,23,203,21,23,125,
  23,243,211,153,62,142,211,153,225,125,211,153,201,205,71,6,219,152,201,245,205,81,6,241,211,152,201,243,211,153,62,143,
  211,153,219,153,245,175,211,153,62,143,211,153,251,241,201,219,153,1,0,0,205,46,2,1,1,224,205,46,2,1,2,0,
  205,46,2,1,3,128,205,46,2,1,4,1,205,46,2,1,8,8,205,46,2,62,1,50,220,243,50,221,243,205,90,7,
  62,0,33,0,8,1,0,8,205,133,2,62,245,33,0,32,1,32,0,205,133,2,1,7,245,205,46,2,33,191,27,17,
  0,8,1,0,8,205,195,2,201,1,20,0,205,46,2,1,21,59,205,46,2,1,22,5,205,46,2,201,33,191,27,237,
  91,36,249,1,0,8,195,195,2,192,58,175,252,254,9,208,229,33,57,7,205,0,2,225,201,75,7,90,7,118,7,140,
  7,118,7,160,7,176,7,195,7,211,7,58,176,243,254,40,1,192,3,56,8,1,128,7,24,3,1,0,3,42,34,249,
  62,32,205,133,2,62,1,33,178,251,119,17,179,251,1,23,0,237,176,195,234,18,175,1,0,24,42,36,249,111,197,205,
  133,2,193,58,234,243,42,201,243,195,133,2,58,234,243,230,15,71,7,7,7,7,176,1,0,8,42,36,249,195,133,2,
  58,234,243,230,15,71,7,7,7,7,176,33,0,1,24,41,58,234,243,230,3,71,7,7,176,7,7,7,7,176,33,0,
  2,24,22,58,234,243,230,15,71,7,7,7,7,176,33,0,2,24,6,58,234,243,33,0,1,245,205,37,8,241,14,44,
  205,27,8,14,40,205,21,8,33,212,0,14,42,205,21,8,33,0,0,14,36,205,21,8,58,246,250,103,46,0,14,38,
  205,21,8,62,0,14,45,205,27,8,62,192,14,46,205,27,8,205,37,8,201,125,205,27,8,12,124,243,211,153,121,246,
  128,211,153,251,201,62,2,205,155,6,31,56,248,201,237,75,32,249,111,38,0,41,41,41,9,6,8,17,64,252,197,213,
  229,58,31,249,205,210,35,225,209,193,18,19,35,16,239,201,229,245,33,91,8,205,171,9,241,225,201,82,73,71,72,84,
  67,0,229,245,33,109,8,205,171,9,241,225,201,76,69,70,84,67,0,229,245,33,126,8,205,171,9,241,225,201,85,80,
  67,0,229,245,33,141,8,205,171,9,241,225,201,84,85,80,67,0,229,245,33,157,8,205,171,9,241,225,201,68,79,87,
  78,67,0,229,245,33,174,8,205,171,9,241,225,201,84,68,79,87,78,67,0,237,75,183,252,237,91,185,252,201,83,67,
  65,76,88,89,0,197,237,67,183,252,237,83,185,252,42,185,252,41,41,41,41,41,46,0,6,0,62,255,50,44,249,121,
  230,7,40,10,71,62,255,167,31,16,252,50,44,249,121,230,248,79,6,0,9,34,42,249,193,201,77,65,80,88,89,0,
  58,44,249,42,42,249,201,70,69,84,67,72,67,0,229,245,33,25,9,205,171,9,241,225,201,83,84,79,82,69,67,0,
  229,245,33,43,9,205,171,9,241,225,201,83,69,84,65,84,82,0,229,245,33,61,9,205,171,9,241,225,201,82,69,65,
  68,67,0,229,245,33,78,9,205,171,9,241,225,201,83,69,84,67,0,229,245,33,94,9,205,171,9,241,225,201,78,83,
  69,84,67,88,0,229,245,33,112,9,205,171,9,241,225,201,71,84,65,83,80,67,0,229,245,33,130,9,205,171,9,241,
  225,201,80,78,84,73,78,73,0,229,245,33,148,9,205,171,9,241,225,201,83,67,65,78,82,0,229,245,33,165,9,205,
  171,9,241,225,201,83,67,65,78,76,0,62,35,211,46,205,183,9,62,0,211,46,201,126,35,183,200,211,47,24,248,230,
  15,254,10,48,5,198,48,211,47,201,198,55,211,47,201,245,15,15,15,15,205,191,9,241,205,191,9,201,124,205,207,9,
  125,205,207,9,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,201,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,62,130,211,171,62,80,211,170,175,211,255,60,211,254,
  60,211,253,60,211,252,33,255,255,217,219,168,246,240,71,120,211,168,58,255,255,47,246,240,79,121,50,255,255,33,0,255,
  62,15,119,190,32,8,47,119,190,32,3,37,24,242,36,124,183,40,21,217,188,56,5,40,3,217,24,12,46,0,103,217,
  120,217,71,217,121,217,79,217,121,214,16,79,48,203,120,214,16,71,48,187,217,125,183,40,6,17,10,38,195,76,27,120,
  211,168,121,50,255,255,217,33,0,243,249,205,83,15,205,151,16,205,222,16,205,175,6,251,205,243,17,6,15,17,79,14,
  33,0,128,197,229,213,58,193,252,205,210,35,225,209,193,190,32,18,235,19,35,16,236,221,33,16,128,253,42,192,252,205,
  71,36,24,17,62,5,50,234,243,50,235,243,205,157,3,33,105,37,205,51,17,243,62,4,211,153,62,142,211,153,175,211,
  153,246,64,211,153,62,118,211,152,175,211,153,33,252,250,211,153,219,152,254,118,40,4,203,206,24,2,203,214,175,211,153,
  62,142,211,153,251,6,120,205,47,17,205,191,35,62,4,50,235,243,62,4,50,234,243,62,15,50,233,243,62,29,50,175,
  243,205,157,3,221,33,65,1,205,243,26,33,105,37,205,51,17,205,94,14,205,218,254,205,61,15,62,1,50,153,253,175,
  50,41,251,205,203,254,33,68,38,205,51,17,195,25,27,67,45,66,73,79,83,32,76,111,103,111,32,82,79,77,33,201,
  252,17,202,252,1,63,0,54,0,237,176,33,193,252,175,229,182,33,0,64,205,165,14,204,178,14,33,0,128,205,165,14,
  204,178,14,203,127,40,6,198,4,203,103,40,228,225,35,60,230,3,32,219,201,71,205,210,35,35,245,120,205,210,35,35,
  87,241,95,120,201,229,205,149,14,33,65,66,205,198,17,120,225,201,229,245,33,210,37,205,51,17,241,245,71,230,3,198,
  48,205,89,18,120,203,120,40,15,62,46,205,89,18,120,15,15,230,3,198,48,205,89,18,62,13,205,89,18,62,10,205,
  89,18,241,225,35,35,205,52,15,40,21,79,213,221,225,245,253,225,219,153,183,250,242,14,245,229,205,71,36,243,225,241,
  14,0,205,52,15,40,2,203,233,205,52,15,40,2,203,241,205,52,15,40,2,203,249,71,230,12,95,120,7,7,7,7,
  230,48,179,95,124,7,7,230,3,179,33,201,252,22,0,95,25,113,120,201,197,205,149,14,122,179,120,193,201,33,201,252,
  6,64,126,203,127,40,8,229,33,229,37,205,51,17,225,35,16,240,201,62,0,33,128,243,119,17,129,243,1,125,12,237,
  176,62,201,33,0,243,119,17,1,243,1,127,0,237,176,62,201,33,154,253,119,17,155,253,1,77,2,237,176,62,255,33,
  218,251,119,17,219,251,1,21,0,237,176,62,0,33,240,251,119,17,241,251,1,39,0,237,176,62,0,33,231,255,119,17,
  232,255,1,15,0,237,176,62,8,50,231,255,62,0,50,232,255,33,240,251,34,248,243,34,250,243,217,34,72,252,217,33,
  128,243,34,74,252,34,116,246,33,78,37,17,128,243,1,26,0,237,176,33,0,0,34,179,243,33,0,8,34,183,243,33,
  0,24,34,189,243,33,0,32,34,191,243,33,0,0,34,193,243,33,0,27,34,195,243,33,0,56,34,197,243,33,0,24,
  34,199,243,33,0,32,34,201,243,33,0,0,34,203,243,33,0,27,34,205,243,33,0,56,34,207,243,33,0,8,34,209,
  243,33,0,0,34,213,243,33,0,27,34,215,243,33,0,56,34,217,243,33,89,249,34,243,243,33,117,249,34,93,249,33,
  245,249,34,99,249,33,117,250,34,105,249,62,127,50,92,249,50,98,249,50,104,249,62,39,50,174,243,62,32,50,175,243,
  58,175,243,50,176,243,62,24,50,177,243,62,4,50,235,243,62,4,50,234,243,62,15,50,233,243,62,160,50,224,243,58,
  193,252,50,31,249,42,4,0,34,32,249,62,195,33,89,18,34,229,254,50,228,254,201,243,33,193,252,219,168,87,230,63,
  79,211,168,58,255,255,47,95,230,15,50,255,255,71,58,255,255,47,184,32,21,123,230,15,246,80,50,255,255,71,58,255,
  255,47,184,32,5,6,128,123,24,4,6,0,123,47,50,255,255,122,211,168,112,35,121,198,64,79,48,197,251,201,1,0,
  4,33,193,252,197,229,121,182,203,127,32,5,205,13,17,24,3,205,0,17,225,193,216,35,12,16,233,175,50,248,250,201,
  6,4,197,205,13,17,193,216,198,4,16,246,201,79,50,248,250,33,0,0,205,38,17,254,67,32,6,35,205,38,17,254,
  68,121,55,200,183,201,121,197,229,205,210,35,225,193,201,118,16,253,201,58,175,252,254,5,48,9,126,183,200,205,89,18,
  35,24,247,126,183,200,221,33,137,0,205,243,26,35,24,243,14,32,58,175,252,183,192,14,40,58,176,243,254,41,216,14,
  80,201,197,245,205,80,17,58,176,243,237,68,129,60,203,63,111,58,221,243,61,133,111,38,0,68,58,220,243,61,203,63,
  48,1,9,203,33,203,16,183,32,244,237,75,34,249,9,241,193,201,229,245,33,157,17,205,171,9,241,225,201,83,89,78,
  67,72,82,0,205,72,255,126,35,254,0,200,254,58,200,254,48,56,3,254,58,216,254,32,40,237,254,9,40,233,183,201,
  245,205,228,254,241,201,124,186,192,125,187,201,229,245,33,215,17,205,171,9,241,225,201,71,69,84,89,80,82,0,8,217,
  225,126,35,94,35,86,35,213,221,225,245,253,225,229,8,217,195,71,36,30,143,62,15,205,6,24,195,238,23,229,245,33,
  8,18,205,171,9,241,225,201,73,78,73,70,78,75,0,229,245,33,26,18,205,171,9,241,225,201,83,84,82,84,77,83,
  0,251,229,213,42,250,243,237,91,248,243,231,62,255,32,1,175,209,225,201,205,194,253,229,213,42,250,243,237,91,248,243,
  231,32,4,251,118,24,242,126,245,35,125,254,24,32,3,33,240,251,34,250,243,241,209,225,201,229,213,197,245,205,164,253,
  58,175,252,254,2,48,19,241,245,205,184,20,241,245,205,127,18,205,205,20,58,221,243,50,97,246,241,193,209,225,201,205,
  197,21,208,40,18,245,58,167,252,183,194,98,19,241,254,32,56,42,254,127,202,170,20,205,98,17,205,87,2,42,220,243,
  58,176,243,36,188,56,4,34,220,243,201,17,177,251,38,0,25,175,119,42,220,243,205,17,19,195,211,18,6,12,33,60,
  21,195,8,2,62,32,205,151,18,58,221,243,230,7,254,1,32,242,201,42,220,243,58,177,243,44,189,48,9,229,205,234,
  18,205,53,20,225,45,34,220,243,201,33,1,1,34,220,243,201,205,211,19,42,220,243,229,205,17,19,58,220,243,33,177,
  243,190,48,8,205,211,18,205,211,19,24,239,225,34,220,243,201,62,1,50,221,243,201,62,255,50,167,252,201,58,221,243,
  33,176,243,190,48,3,60,24,31,58,220,243,33,177,243,190,208,60,50,220,243,24,218,58,221,243,61,32,11,58,220,243,
  61,200,50,220,243,58,176,243,50,221,243,201,58,220,243,61,200,50,220,243,201,58,220,243,33,177,243,190,208,60,50,220,
  243,201,71,60,32,12,50,167,252,241,6,15,33,96,21,195,8,2,241,16,4,14,0,24,4,16,24,14,1,254,52,40,
  6,254,53,40,8,24,46,121,50,170,252,24,40,121,50,169,252,24,34,16,8,6,31,144,50,221,243,24,24,16,22,6,
  31,144,50,220,243,62,3,24,13,62,1,24,9,62,2,24,5,62,4,24,1,175,50,167,252,201,58,221,243,33,176,243,
  190,208,60,50,221,243,201,58,221,243,61,200,50,221,243,201,205,17,19,33,177,251,58,220,243,95,22,0,25,119,58,176,
  243,60,33,221,243,150,79,6,0,62,32,205,98,17,195,133,2,205,17,19,42,220,243,229,69,58,177,243,50,220,243,144,
  71,4,58,220,243,24,14,205,98,17,235,61,50,220,243,205,98,17,205,115,20,16,240,225,34,220,243,38,0,58,177,243,
  87,30,0,149,61,79,6,0,33,177,251,25,235,98,107,43,237,184,195,211,19,205,17,19,42,220,243,229,69,58,177,243,
  144,71,4,58,220,243,24,14,205,98,17,235,60,50,220,243,205,98,17,205,115,20,16,240,205,211,19,225,34,220,243,38,
  0,58,177,243,149,61,79,6,0,17,177,251,25,84,93,35,237,176,201,245,197,6,0,58,176,243,79,254,41,56,11,14,
  40,205,144,20,58,176,243,214,40,79,205,144,20,193,241,201,229,213,197,17,24,252,205,164,2,193,209,213,197,33,24,252,
  205,195,2,193,225,9,235,225,9,201,58,221,243,254,1,200,62,32,205,151,18,195,55,19,58,169,252,254,1,192,58,175,
  252,254,2,208,58,204,251,205,98,17,195,87,2,58,169,252,254,1,192,58,175,252,254,2,208,205,98,17,205,81,2,50,
  204,251,167,22,0,95,203,19,203,18,203,19,203,18,203,19,203,18,175,33,175,252,190,32,5,42,183,243,24,3,42,193,
  243,229,25,17,24,252,1,8,0,205,164,2,58,170,252,254,0,32,7,33,24,252,6,8,24,5,33,30,252,6,2,126,
  47,119,35,16,250,225,17,248,7,25,235,33,24,252,1,8,0,205,195,2,205,98,17,62,255,195,87,2,7,10,23,8,
  55,19,9,196,18,10,211,18,11,234,18,12,42,7,13,17,19,27,23,19,28,29,19,29,55,19,30,76,19,31,85,19,
  106,42,7,69,42,7,75,211,19,74,241,18,108,208,19,76,241,19,77,53,20,89,177,19,65,76,19,66,85,19,67,186,
  19,68,199,19,72,234,18,120,169,19,121,173,19,205,182,255,245,205,217,22,56,8,205,183,21,40,246,241,24,12,62,13,
  205,170,21,175,50,21,244,241,55,201,245,211,145,62,0,211,144,47,211,144,241,167,201,205,187,255,219,144,31,31,62,255,
  48,1,47,167,201,229,245,33,166,252,175,190,119,32,8,241,254,1,32,19,119,24,17,241,254,64,56,9,254,96,48,5,
  214,64,191,24,2,254,80,55,225,201,205,219,253,58,170,246,167,202,8,22,62,1,50,221,243,195,8,22,63,32,0,205,
  224,253,33,252,21,205,51,17,42,221,243,34,202,251,17,176,251,38,0,125,25,119,205,52,18,254,127,202,152,22,254,32,
  48,17,6,20,33,153,22,205,0,2,175,50,168,252,50,170,252,24,227,245,58,168,252,167,196,63,22,241,223,24,201,205,
  184,20,42,220,243,34,188,246,62,32,50,167,246,205,98,17,205,81,2,254,32,32,40,42,220,243,58,176,243,188,32,29,
  38,0,17,177,251,25,126,183,40,19,58,167,246,205,98,17,205,87,2,42,188,246,34,220,243,201,195,205,20,62,32,245,
  58,167,246,223,241,50,167,246,24,195,201,55,225,201,201,201,201,201,175,225,201,201,201,201,201,24,0,24,0,138,22,139,
  22,24,0,142,22,143,22,24,0,144,22,24,0,24,0,24,0,24,0,145,22,146,22,24,0,24,0,24,0,149,22,24,
  0,24,0,150,22,24,0,24,0,24,0,24,0,24,0,151,22,24,0,24,0,24,0,24,0,219,170,230,240,246,7,211,
  170,219,169,230,16,192,219,170,230,240,246,6,211,170,219,169,230,2,192,55,201,229,245,33,0,23,205,171,9,241,225,201,
  73,83,67,78,84,67,0,195,245,22,229,245,33,21,23,205,171,9,241,225,201,66,69,69,80,0,34,220,243,201,229,245,
  33,41,23,205,171,9,241,225,201,70,78,75,83,66,0,229,245,33,58,23,205,171,9,241,225,201,69,82,65,70,78,75,
  0,229,245,33,76,23,205,171,9,241,225,201,68,83,80,70,78,75,0,58,175,252,254,2,216,58,176,252,205,189,253,183,
  202,148,3,195,157,3,229,245,33,114,23,205,171,9,241,225,55,201,84,65,80,73,79,78,0,229,245,33,133,23,205,171,
  9,241,225,55,201,84,65,80,73,78,0,229,245,33,150,23,205,171,9,241,225,201,84,65,80,73,79,70,0,229,245,33,
  169,23,205,171,9,241,225,55,201,84,65,80,79,79,78,0,229,245,33,188,23,205,171,9,241,225,55,201,84,65,80,79,
  85,84,0,229,245,33,206,23,205,171,9,241,225,201,84,65,80,79,79,70,0,197,71,219,170,4,40,12,203,231,5,40,
  9,203,167,5,40,4,193,201,238,16,211,170,193,201,30,0,62,8,205,6,24,60,205,6,24,60,205,6,24,60,30,184,
  62,7,205,6,24,201,243,211,160,245,123,211,161,251,241,201,211,160,219,162,201,183,62,14,40,1,60,211,171,201,219,168,
  201,211,168,201,219,153,201,243,197,79,219,170,230,240,177,211,170,219,169,193,251,201,205,167,255,201,205,172,255,201,58,100,
  248,167,201,197,254,0,32,25,62,8,205,39,24,15,15,15,15,47,230,15,229,33,166,24,22,0,95,25,126,225,193,167,
  201,229,213,30,0,61,40,2,203,243,62,15,243,205,16,24,251,230,191,179,95,62,15,205,6,24,62,14,243,205,16,24,
  251,47,230,15,33,150,24,6,0,79,9,126,209,225,193,167,201,62,0,193,167,201,0,1,5,0,7,8,6,7,3,2,
  4,3,0,1,5,0,0,7,1,8,5,6,0,7,3,0,2,1,4,5,3,0,254,5,48,3,183,32,9,62,8,205,
  39,24,246,254,60,201,243,61,213,30,3,71,230,1,40,2,30,76,62,15,205,16,24,230,191,179,95,62,15,205,6,24,
  120,6,16,230,2,40,2,6,32,62,14,243,205,16,24,251,209,160,40,2,24,3,62,255,201,175,201,229,245,33,7,25,
  205,171,9,241,225,175,201,71,84,80,65,68,0,229,245,33,24,25,205,171,9,241,225,201,71,84,80,68,76,0,205,78,
  25,70,4,35,126,144,35,35,166,111,38,0,201,205,78,25,126,60,71,35,150,200,120,35,35,229,166,43,43,43,119,225,
  35,126,35,102,111,5,72,6,0,9,115,246,1,201,42,243,243,71,7,7,128,128,79,6,0,9,201,183,219,170,203,183,
  32,2,203,247,211,170,201,229,245,33,114,25,205,171,9,241,225,201,79,85,84,68,76,80,0,46,2,24,3,58,56,251,
  213,22,0,93,33,65,251,25,30,37,183,40,4,25,61,24,249,209,201,42,250,243,34,248,243,201,229,213,197,245,217,8,
  229,213,197,245,253,229,221,229,205,154,253,219,153,183,50,231,243,242,2,26,205,159,253,42,158,252,35,34,158,252,175,50,
  217,251,58,246,243,61,50,246,243,32,55,62,3,50,246,243,175,205,182,24,47,230,1,50,232,243,205,23,26,42,248,243,
  237,91,250,243,231,32,27,58,247,243,61,50,247,243,32,18,33,218,251,1,255,11,113,35,16,252,205,23,26,62,1,50,
  247,243,221,225,253,225,241,193,209,225,217,8,241,193,209,225,251,201,205,214,253,237,69,219,170,230,240,79,6,11,33,229,
  251,121,211,170,219,169,119,35,12,16,246,221,33,218,251,17,229,251,58,235,251,15,33,211,38,56,3,33,3,39,14,11,
  26,221,190,0,196,104,26,47,221,166,0,8,26,221,119,0,8,6,8,15,56,26,35,16,250,221,35,19,13,200,121,254,
  5,32,221,33,243,39,24,216,245,62,5,50,247,243,241,201,245,121,254,5,40,7,254,4,40,28,195,199,26,120,254,3,
  32,4,62,0,24,33,254,2,32,4,62,1,24,25,254,1,32,53,62,2,24,17,120,254,8,32,4,62,3,24,8,254,
  7,32,36,62,4,24,0,229,197,213,7,7,7,7,33,127,248,22,0,95,25,235,26,167,40,8,213,205,212,26,209,19,
  24,244,209,193,225,24,9,126,167,40,5,229,205,212,26,225,241,195,86,26,42,248,243,119,35,125,254,24,32,3,33,240,
  251,213,237,91,250,243,231,209,200,34,248,243,201,205,243,26,221,225,201,8,217,245,197,213,229,237,87,245,217,253,229,58,
  248,250,245,253,225,8,205,71,36,253,225,8,217,241,226,18,27,251,225,209,193,241,217,8,201,24,254,205,218,254,17,55,
  38,195,76,27,229,245,33,52,27,205,171,9,241,225,17,28,38,195,76,27,67,65,76,66,65,83,0,237,91,220,243,213,
  34,220,243,205,211,19,209,237,83,220,243,201,219,153,33,27,40,6,12,14,153,237,179,1,0,8,175,211,152,11,120,177,
  32,248,33,191,27,1,0,8,126,211,152,35,11,120,177,32,247,62,0,211,153,62,64,211,153,33,3,38,126,211,152,35,
  126,167,32,249,26,211,152,19,26,167,32,249,195,25,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,60,66,165,165,195,189,66,60,60,126,219,219,189,195,126,60,108,170,146,68,68,40,16,0,16,
  40,68,130,68,40,16,0,16,56,56,214,254,214,56,0,16,56,124,124,254,214,56,0,0,0,0,24,24,0,0,0,255,
  255,255,231,231,255,255,255,60,66,129,129,129,129,66,60,195,189,126,126,126,126,189,195,12,4,8,112,136,136,112,0,0,
  112,136,136,112,32,112,32,32,48,40,40,32,224,192,0,56,60,36,36,228,220,24,0,16,68,56,170,56,68,16,0,16,
  16,16,56,16,16,16,16,16,16,16,239,0,0,0,0,0,0,0,239,16,16,16,16,16,16,16,224,16,16,16,16,16,
  16,16,15,16,16,16,16,16,16,16,239,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,255,0,0,0,0,0,
  0,0,15,16,16,16,16,0,0,0,224,16,16,16,16,16,16,16,15,0,0,0,0,16,16,16,224,0,0,0,0,129,
  66,36,24,24,36,66,129,1,2,4,8,16,32,64,128,128,64,32,16,8,4,2,1,0,0,16,255,16,0,0,0,0,
  0,0,0,0,0,0,0,32,32,32,32,0,32,0,0,80,80,0,0,0,0,0,0,0,80,248,80,248,80,0,0,32,
  112,160,112,40,112,32,0,0,200,208,32,88,152,0,0,96,144,96,168,152,96,0,0,64,64,0,0,0,0,0,0,32,
  64,64,64,64,32,0,0,32,16,16,16,16,32,0,0,0,32,168,112,80,136,0,0,0,32,32,248,32,32,0,0,0,
  0,0,0,0,64,64,0,0,0,0,248,0,0,0,0,0,0,0,0,0,64,0,0,0,8,16,32,64,128,0,0,112,
  136,168,168,136,112,0,0,32,96,32,32,32,112,0,0,112,136,8,112,128,248,0,0,248,8,48,8,136,112,0,0,16,
  48,80,248,16,16,0,0,248,128,112,8,136,112,0,0,48,64,112,136,136,112,0,0,248,136,16,32,32,32,0,0,112,
  136,112,136,136,112,0,0,112,136,136,120,8,112,0,0,0,0,64,0,0,64,0,0,0,0,64,0,0,64,64,0,0,
  24,96,128,96,24,0,0,0,0,248,0,248,0,0,0,0,192,48,8,48,192,0,0,112,136,48,32,0,32,0,0,112,
  136,152,168,168,152,64,0,112,136,136,248,136,136,0,0,224,144,224,144,136,240,0,0,112,136,128,128,136,112,0,0,240,
  72,72,72,72,240,0,0,248,128,224,128,128,248,0,0,248,128,128,224,128,128,0,0,112,136,128,184,136,112,0,0,136,
  136,248,136,136,136,0,0,112,32,32,32,32,112,0,0,56,8,8,8,136,112,0,0,136,144,160,224,144,136,0,0,128,
  128,128,128,128,248,0,0,216,168,168,136,136,136,0,0,200,168,168,152,152,136,0,0,112,136,136,136,136,112,0,0,240,
  136,136,240,128,128,0,0,112,136,136,168,144,104,0,0,240,136,136,240,160,152,0,0,112,128,112,8,8,240,0,0,248,
  32,32,32,32,32,0,0,136,136,136,136,136,120,0,0,136,136,136,80,80,32,0,0,136,136,168,168,168,216,0,0,136,
  80,32,80,136,136,0,0,136,136,112,32,32,32,0,0,248,16,32,64,128,248,0,0,112,64,64,64,64,112,0,0,0,
  128,64,32,16,8,0,0,112,16,16,16,16,112,0,0,64,160,0,0,0,0,0,0,0,0,0,0,0,0,248,0,32,
  16,0,0,0,0,0,0,0,0,120,136,152,104,0,0,128,128,240,136,136,240,0,0,0,0,120,128,128,120,0,0,8,
  8,120,136,136,120,0,0,0,0,112,152,224,120,0,0,48,72,64,64,224,64,64,64,0,0,120,136,136,120,8,112,128,
  128,240,136,136,136,0,0,32,0,96,32,32,112,0,0,16,0,48,16,16,16,16,96,128,128,152,160,224,152,0,0,192,
  64,64,64,64,112,0,0,0,0,240,168,168,168,0,0,0,0,240,136,136,136,0,0,0,0,112,136,136,112,0,0,0,
  0,240,136,136,240,128,128,0,0,120,136,136,120,8,8,0,0,184,192,128,128,0,0,0,0,120,240,8,240,0,0,64,
  64,240,64,72,48,0,0,0,0,136,136,136,120,0,0,0,0,136,136,80,32,0,0,0,0,136,168,168,216,0,0,0,
  0,200,48,96,152,0,0,0,0,136,136,136,120,8,112,0,0,248,48,64,248,0,0,16,32,32,64,32,32,16,0,32,
  32,32,32,32,32,32,0,64,32,32,16,32,32,64,0,80,160,0,0,0,0,0,0,0,32,80,80,248,0,0,0,112,
  136,128,128,136,112,32,64,80,0,136,136,136,120,0,0,8,16,112,152,224,120,0,0,32,80,120,136,152,104,0,0,80,
  0,120,136,152,104,0,0,64,32,120,136,152,104,0,0,32,0,120,136,152,104,0,0,0,0,120,128,128,120,32,64,32,
  80,112,152,224,120,0,0,80,0,112,152,224,120,0,0,64,32,112,152,224,120,0,0,80,0,96,32,32,112,0,0,32,
  80,96,32,32,112,0,0,64,32,96,32,32,112,0,0,80,112,136,136,248,136,0,0,32,112,136,136,248,136,0,0,24,
  248,128,224,128,248,0,0,0,0,208,104,176,216,0,0,120,160,176,224,160,184,0,0,32,80,112,136,136,112,0,0,80,
  0,112,136,136,112,0,0,64,32,112,136,136,112,0,0,32,80,136,136,136,120,0,0,64,32,136,136,136,120,0,0,80,
  0,136,136,136,120,8,112,80,112,136,136,136,112,0,0,80,136,136,136,136,112,0,0,32,32,120,128,128,120,32,32,32,
  80,64,224,64,72,176,0,136,136,80,248,32,112,32,0,128,208,176,176,184,208,136,128,56,64,240,64,240,64,56,0,8,
  16,120,136,152,104,0,0,16,32,96,32,32,112,0,0,16,32,112,136,136,112,0,0,16,32,136,136,136,120,0,0,40,
  80,240,136,136,136,0,0,40,208,168,168,152,136,0,0,0,0,120,136,152,104,0,112,0,0,112,136,136,112,0,112,32,
  0,32,96,136,112,0,0,0,0,0,224,128,0,0,0,0,0,0,224,32,0,0,0,64,72,80,48,72,144,56,0,64,
  72,80,40,88,184,8,0,32,0,32,32,32,32,0,0,0,0,0,72,144,72,0,0,0,0,0,144,72,144,0,0,40,
  80,112,136,248,136,0,0,40,80,120,136,152,104,0,0,40,80,112,32,32,112,0,0,40,80,96,32,32,112,0,0,40,
  112,136,136,136,112,0,0,40,80,112,136,136,112,0,0,40,80,136,136,136,120,0,0,40,80,0,136,136,120,0,0,252,
  72,72,72,72,232,8,48,72,0,216,72,72,232,8,48,224,104,48,232,88,184,8,0,80,40,0,0,0,0,0,0,0,
  32,80,136,80,32,0,0,0,72,80,32,104,168,0,0,124,168,168,168,104,40,40,68,112,128,112,136,112,8,136,112,0,
  0,0,0,0,0,255,255,240,240,240,240,15,15,15,15,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,
  0,0,60,60,0,0,0,255,255,255,255,255,255,0,0,192,192,192,192,192,192,192,192,15,15,15,15,240,240,240,240,252,
  252,252,252,252,252,252,252,3,3,3,3,3,3,3,3,63,63,63,63,63,63,63,63,17,34,68,136,17,34,68,136,136,
  68,34,17,136,68,34,17,254,124,56,16,0,0,0,0,0,0,0,0,16,56,124,254,128,192,224,240,224,192,128,0,1,
  3,7,15,7,3,1,0,255,126,60,24,24,60,126,255,129,195,231,255,255,231,195,129,240,240,240,240,0,0,0,0,0,
  0,0,0,15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,0,240,240,240,240,51,51,204,204,51,51,204,204,0,
  16,40,40,124,0,0,0,16,16,56,16,56,16,16,0,0,0,80,136,168,80,0,0,255,255,255,255,255,255,255,255,0,
  0,0,0,255,255,255,255,240,240,240,240,240,240,240,240,15,15,15,15,15,15,15,15,255,255,255,255,0,0,0,0,0,
  0,104,144,144,104,0,0,96,144,224,144,144,224,128,0,248,136,128,128,128,128,0,0,248,80,80,80,80,72,128,0,248,
  72,32,64,136,248,0,0,0,0,120,144,136,112,0,0,0,0,136,136,200,176,128,128,0,0,80,80,32,80,80,32,112,
  32,112,168,168,112,32,112,112,136,248,136,136,112,0,0,112,136,136,136,80,216,0,0,48,64,48,72,72,48,0,0,0,
  0,80,168,168,80,0,0,0,16,112,168,168,112,64,0,0,112,128,224,128,112,0,0,112,136,136,136,136,136,0,0,0,
  248,0,248,0,248,0,0,0,32,32,248,32,32,248,0,0,192,48,8,48,192,248,0,0,24,96,128,96,24,248,0,0,
  24,32,32,32,32,32,32,32,32,32,32,32,32,192,0,0,32,0,248,0,32,0,0,0,104,176,0,104,176,0,0,0,
  48,72,72,48,0,0,0,0,48,120,120,48,0,0,0,0,0,0,0,48,0,0,0,28,16,16,144,80,48,16,0,224,
  144,144,0,0,0,0,0,96,16,96,240,0,0,0,0,0,112,112,112,112,112,112,0,170,85,170,85,170,85,170,85,175,
  211,153,246,64,211,153,1,0,64,175,211,152,11,120,177,32,248,201,197,229,245,87,167,243,252,241,36,241,225,229,213,229,
  245,124,7,7,230,3,111,71,62,252,205,11,36,95,69,241,230,3,205,11,36,71,219,168,87,163,176,225,205,128,243,123,
  209,245,203,122,196,45,37,241,225,193,201,4,5,200,7,7,16,252,201,229,87,213,167,243,252,241,36,193,225,213,229,124,
  7,7,230,3,111,71,62,252,205,11,36,95,69,122,230,3,205,11,36,71,219,168,87,163,176,225,89,205,133,243,209,229,
  203,122,196,45,37,225,201,8,217,243,253,229,241,221,229,225,87,167,252,241,36,213,122,230,3,71,14,252,221,229,241,7,
  7,230,3,135,40,7,203,0,203,1,61,32,249,33,122,36,229,219,168,245,161,176,217,195,140,243,8,217,243,209,203,122,
  196,45,37,8,217,201,243,229,111,230,3,71,62,171,198,85,5,242,142,36,87,124,7,7,230,3,103,71,62,192,7,7,
  5,242,158,36,95,47,79,122,163,71,125,167,242,233,36,15,15,230,3,229,197,71,62,171,198,85,5,242,184,36,163,71,
  122,230,192,103,219,168,111,230,192,180,211,168,58,255,255,47,161,176,79,50,255,255,125,211,168,33,197,252,122,230,3,133,
  111,124,206,0,103,121,119,193,225,219,168,161,176,211,168,225,201,87,15,15,95,230,192,111,219,168,79,230,63,181,211,168,
  123,230,3,111,124,38,3,24,2,41,41,214,64,48,250,124,47,103,58,255,255,47,95,164,181,50,255,255,111,121,211,168,
  122,230,3,79,6,0,125,33,197,252,9,119,201,122,15,15,230,192,71,219,168,79,230,63,176,211,168,123,50,255,255,121,
  211,168,122,230,3,79,6,0,33,197,252,9,115,201,211,168,94,24,3,211,168,115,122,211,168,201,211,168,8,205,152,243,
  8,241,211,168,8,201,221,233,0,67,45,66,73,79,83,32,48,46,50,57,32,32,32,32,32,32,99,98,105,111,115,46,
  115,102,46,110,101,116,13,10,67,104,97,114,97,99,116,101,114,32,115,101,116,58,32,85,83,13,10,68,101,102,97,117,
  108,116,32,105,110,116,101,114,114,117,112,116,32,102,114,101,113,46,58,32,54,48,72,122,75,101,121,98,111,97,114,100,
  32,116,121,112,101,58,32,85,83,13,10,13,10,13,10,13,10,0,73,110,105,116,32,82,79,77,32,105,110,32,115,108,
  111,116,58,32,0,67,97,110,110,111,116,32,101,120,101,99,117,116,101,32,97,32,66,65,83,73,67,32,82,79,77,46,
  13,10,0,69,82,82,79,82,58,0,77,69,77,79,82,89,32,78,79,84,32,70,79,85,78,68,46,0,67,65,76,76,
  69,68,32,78,79,78,32,69,88,73,83,84,73,78,71,32,66,65,83,73,67,46,0,83,84,65,67,75,32,69,82,82,
  79,82,46,0,13,10,13,10,78,111,32,99,97,114,116,114,105,100,103,101,32,102,111,117,110,100,46,13,10,13,10,84,
  104,105,115,32,118,101,114,115,105,111,110,32,111,102,32,67,45,66,73,79,83,32,99,97,110,13,10,111,110,108,121,32,
  115,116,97,114,116,32,99,97,114,116,114,105,100,103,101,115,46,13,10,80,108,101,97,115,101,32,114,101,115,116,97,114,
  116,32,121,111,117,114,32,77,83,88,13,10,40,101,109,117,108,97,116,111,114,41,32,119,105,116,104,32,97,32,99,97,
  114,116,114,105,100,103,101,13,10,105,110,115,101,114,116,101,100,46,0,48,49,50,51,52,53,54,55,56,57,45,61,92,
  91,93,59,39,96,44,46,47,0,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,
  120,121,122,41,33,64,35,36,37,94,38,42,40,95,43,124,123,125,58,34,126,60,62,63,0,65,66,67,68,69,70,71,
  72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,9,172,171,186,239,189,244,251,236,7,23,241,30,
  1,13,6,5,187,243,242,29,0,196,17,188,199,205,20,21,19,220,198,221,200,11,27,194,219,204,24,210,18,192,26,207,
  28,25,15,10,0,253,252,0,0,245,0,0,8,31,240,22,2,14,4,3,247,174,175,246,0,254,0,250,193,206,212,16,
  214,223,202,222,201,12,211,195,215,203,169,209,0,197,213,208,249,170,248,235,159,217,191,155,152,224,225,231,135,238,233,0,
  237,218,183,185,229,134,166,167,0,132,151,141,139,140,148,129,177,161,145,179,181,230,164,162,163,131,147,137,150,130,149,136,
  138,160,133,216,173,158,190,156,157,0,0,226,128,0,0,0,232,234,182,184,228,143,0,168,0,142,0,0,0,0,153,154,
  176,0,146,178,180,0,165,0,227,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,9,0,
  8,0,13,32,12,0,0,29,30,31,28,42,43,47,48,49,50,51,52,53,54,55,56,57,45,44,46,0,128,112,129,0,
  130,1,132,245,135,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,229,193,27,123,178,40,3,9,24,248,193,201,
  229,245,33,181,49,205,171,9,62,32,211,46,122,211,47,123,211,47,241,225,201,82,79,77,66,65,83,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,
  62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,62,58,229,245,
  33,73,58,205,171,9,241,225,201,66,65,83,73,67,32,115,116,97,116,101,109,101,110,116,115,32,97,114,101,32,110,111,
  116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,51,17,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,34,125,205,171,9,241,
  225,201,117,110,107,110,111,119,110,64,55,68,49,55,0,57,125,221,33,137,1,205,243,26,201,221,33,133,1,195,243,26,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,245,33,31,126,205,171,9,241,225,201,117,
  110,107,110,111,119,110,64,55,69,49,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char Sub[16384] = {
  67,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,183,201,0,201,0,0,0,201,0,0,0,201,0,0,0,
  124,186,192,125,187,201,0,0,201,0,0,0,0,0,0,0,201,201,201,201,201,201,201,201,245,197,213,229,8,217,245,197,
  213,229,221,229,253,229,221,33,56,0,253,42,192,252,205,197,2,253,225,221,225,225,209,193,241,8,217,225,209,193,241,237,
  77,201,201,201,201,201,205,214,253,237,69,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
  201,201,201,201,201,251,195,242,14,251,195,4,15,251,195,252,13,251,195,115,15,251,195,121,14,251,195,103,14,251,195,138,
  14,251,195,133,15,251,195,151,13,251,195,151,15,251,195,169,13,251,195,234,13,251,195,217,13,251,195,201,13,251,195,186,
  13,251,195,208,14,251,195,225,14,251,195,169,15,251,195,11,16,251,195,179,4,251,195,197,5,251,195,22,6,251,195,96,
  6,251,195,165,6,251,195,248,6,251,195,80,7,251,195,127,7,251,195,178,7,251,195,102,5,251,195,8,8,251,195,27,
  8,251,195,37,8,251,195,117,13,251,195,202,9,251,195,196,9,251,195,28,5,251,195,110,12,251,195,77,16,201,201,201,
  201,201,201,201,201,201,201,201,201,201,201,201,201,251,195,255,3,251,195,210,9,201,201,201,201,201,201,201,201,251,195,97,
  16,251,195,188,16,251,195,216,16,251,195,239,16,251,195,5,17,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
  201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,251,195,124,
  17,251,195,140,17,251,195,158,17,251,195,176,17,201,201,201,201,251,195,3,18,251,195,28,18,251,195,146,18,251,195,242,
  18,251,195,3,19,251,195,20,19,251,195,37,19,251,195,54,19,201,201,201,201,251,195,72,19,201,201,201,201,251,195,79,
  19,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
  201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,251,195,97,19,251,195,126,19,201,201,201,
  79,6,0,9,9,195,17,2,190,35,40,5,35,35,16,248,201,78,35,102,105,233,62,35,211,46,205,34,2,62,0,211,
  46,201,126,35,183,200,211,47,24,248,230,15,254,10,48,5,198,48,211,47,201,198,55,211,47,201,245,15,15,15,15,205,
  42,2,241,205,42,2,201,124,205,58,2,125,205,58,2,201,197,229,245,87,167,243,252,111,3,241,225,229,213,229,245,124,
  7,7,230,3,111,71,62,252,205,137,2,95,69,241,230,3,205,137,2,71,219,168,87,163,176,225,205,128,243,123,209,245,
  203,122,196,171,3,241,225,193,201,4,5,200,7,7,16,252,201,229,87,213,167,243,252,111,3,193,225,213,229,124,7,7,
  230,3,111,71,62,252,205,137,2,95,69,122,230,3,205,137,2,71,219,168,87,163,176,225,89,205,133,243,209,229,203,122,
  196,171,3,225,201,8,217,243,253,229,241,221,229,225,87,167,252,111,3,213,122,230,3,71,14,252,221,229,241,7,7,230,
  3,135,40,7,203,0,203,1,61,32,249,33,248,2,229,219,168,245,161,176,217,195,140,243,8,217,243,209,203,122,196,171,
  3,8,217,201,243,229,111,230,3,71,62,171,198,85,5,242,12,3,87,124,7,7,230,3,103,71,62,192,7,7,5,242,
  28,3,95,47,79,122,163,71,125,167,242,103,3,15,15,230,3,229,197,71,62,171,198,85,5,242,54,3,163,71,122,230,
  192,103,219,168,111,230,192,180,211,168,58,255,255,47,161,176,79,50,255,255,125,211,168,33,197,252,122,230,3,133,111,124,
  206,0,103,121,119,193,225,219,168,161,176,211,168,225,201,87,15,15,95,230,192,111,219,168,79,230,63,181,211,168,123,230,
  3,111,124,38,3,24,2,41,41,214,64,48,250,124,47,103,58,255,255,47,95,164,181,50,255,255,111,121,211,168,122,230,
  3,79,6,0,125,33,197,252,9,119,201,122,15,15,230,192,71,219,168,79,230,63,176,211,168,123,50,255,255,121,211,168,
  122,230,3,79,6,0,33,197,252,9,115,201,211,168,94,24,3,211,168,115,122,211,168,201,211,168,8,205,152,243,8,241,
  211,168,8,201,221,233,0,58,224,243,230,191,71,14,1,205,255,3,201,58,224,243,246,64,71,14,1,205,255,3,201,243,
  203,185,120,211,153,121,246,128,211,153,251,229,33,223,243,121,254,8,56,7,254,24,48,8,33,223,255,120,6,0,9,119,
  225,201,205,48,4,219,152,201,245,205,66,4,241,211,152,201,243,175,211,153,62,142,211,153,125,211,153,124,230,63,211,153,
  251,201,243,175,211,153,62,142,211,153,125,211,153,124,230,63,246,64,211,153,251,201,245,58,175,252,254,5,48,5,205,66,
  4,24,3,205,136,9,11,12,120,65,79,12,241,211,152,16,252,13,32,249,201,58,175,252,254,4,48,5,205,48,4,24,
  3,205,126,9,229,235,11,12,120,65,60,14,152,237,178,61,32,251,225,201,235,58,175,252,254,4,48,5,205,66,4,24,
  3,205,136,9,235,11,12,120,65,60,14,152,237,179,61,32,251,235,201,254,9,208,33,188,4,195,0,2,197,5,22,6,
  96,6,165,6,115,10,253,10,91,11,183,11,19,12,33,232,255,58,175,252,254,5,48,4,203,190,24,2,203,254,175,50,
  236,255,175,50,246,255,243,33,223,243,1,153,8,22,128,237,163,120,237,81,20,183,32,247,62,8,211,153,62,145,211,153,
  33,231,255,1,155,7,237,179,35,35,35,62,18,211,153,62,145,211,153,1,155,6,237,179,251,195,243,3,58,175,252,254,
  8,40,58,61,245,58,233,243,7,7,7,7,230,240,111,58,235,243,181,71,14,7,205,255,3,241,192,58,233,243,7,7,
  7,7,230,240,33,234,243,182,42,191,243,1,32,0,245,205,66,4,241,211,152,245,11,120,177,32,247,241,201,58,235,243,
  71,14,7,195,255,3,58,175,252,183,200,205,144,5,58,175,252,254,4,56,16,42,40,249,37,37,1,0,2,58,233,243,
  230,15,205,105,9,42,38,249,1,0,8,175,205,105,9,201,58,175,252,254,4,56,4,30,217,24,2,30,209,42,40,249,
  205,136,9,58,233,243,87,1,0,32,243,123,211,152,62,0,211,152,121,211,152,12,205,37,8,48,3,12,12,12,122,211,
  152,16,232,251,201,205,231,3,62,0,50,175,252,50,176,252,175,50,245,250,50,246,250,58,174,243,50,176,243,62,1,50,
  220,243,50,221,243,42,179,243,34,34,249,42,183,243,58,176,243,254,41,56,3,33,0,16,34,36,249,42,185,243,34,40,
  249,42,187,243,34,38,249,205,28,5,205,248,6,205,92,10,205,143,12,195,206,4,205,231,3,62,1,50,175,252,50,176,
  252,62,1,50,220,243,50,221,243,205,28,5,42,189,243,34,34,249,42,193,243,34,36,249,42,197,243,34,38,249,42,195,
  243,34,40,249,205,92,10,58,175,243,50,176,243,175,50,245,250,50,246,250,205,80,7,205,155,5,205,158,12,195,206,4,
  205,231,3,62,2,50,175,252,205,28,5,42,199,243,34,34,249,205,66,4,6,3,175,243,211,152,60,32,251,16,249,251,
  42,203,243,34,36,249,42,205,243,34,40,249,42,207,243,34,38,249,175,50,245,250,50,246,250,205,127,7,205,155,5,205,
  189,12,195,206,4,205,231,3,62,3,50,175,252,205,28,5,42,209,243,34,34,249,205,66,4,175,14,6,243,245,30,4,
  245,6,32,211,152,60,16,251,241,29,32,244,241,198,32,13,32,235,251,42,213,243,34,36,249,42,215,243,34,40,249,42,
  217,243,34,38,249,175,50,245,250,50,246,250,205,178,7,205,155,5,205,211,12,195,206,4,58,176,243,254,41,48,40,58,
  223,243,230,241,71,14,0,205,255,3,58,224,243,230,231,246,16,71,12,205,255,3,17,179,243,14,2,175,205,227,7,19,
  19,12,175,205,227,7,201,58,223,243,230,241,246,4,71,14,0,205,255,3,58,224,243,230,231,246,16,71,12,205,255,3,
  17,34,249,14,2,62,3,205,227,7,12,175,205,227,7,201,58,223,243,230,241,71,14,0,205,255,3,58,224,243,230,231,
  71,12,205,255,3,17,189,243,14,2,175,205,227,7,175,205,227,7,175,205,227,7,175,205,227,7,175,205,227,7,201,58,
  223,243,230,241,246,2,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,17,199,243,14,2,175,205,227,7,62,
  127,205,227,7,62,3,205,227,7,175,205,227,7,175,205,227,7,201,58,223,243,230,241,71,14,0,205,255,3,58,224,243,
  230,231,246,8,71,12,205,255,3,17,209,243,14,2,175,205,227,7,175,205,227,7,175,205,227,7,175,205,227,7,175,205,
  227,7,201,213,245,33,1,8,6,0,9,70,235,126,35,102,111,41,143,16,252,71,241,176,71,205,255,3,209,19,19,12,
  201,0,0,6,10,5,9,5,38,0,111,41,41,41,205,37,8,48,2,41,41,237,91,38,249,25,201,135,135,42,40,249,
  22,0,95,25,201,58,224,243,15,15,62,8,208,62,32,201,245,254,32,56,13,58,175,252,254,2,40,34,254,5,48,28,
  241,201,254,13,32,250,241,229,197,42,185,252,1,8,0,9,34,185,252,33,0,0,34,183,252,193,225,201,241,201,241,229,
  213,197,245,205,117,13,237,91,185,252,237,75,183,252,205,12,14,58,233,243,50,242,243,42,42,249,237,75,203,243,9,17,
  64,252,58,185,252,230,7,6,0,79,9,205,171,8,1,240,0,9,58,185,252,47,230,7,79,205,171,8,42,183,252,1,
  8,0,9,34,183,252,241,193,209,225,201,58,183,252,230,7,245,197,213,229,205,52,9,58,183,252,230,7,40,26,58,44,
  249,47,50,44,249,225,1,8,0,9,209,193,241,205,52,9,58,44,249,47,50,44,249,201,193,1,8,0,9,193,193,241,
  201,245,229,197,213,87,88,237,75,201,243,9,79,58,242,243,230,15,71,205,34,4,245,230,15,184,40,17,241,245,15,15,
  15,15,230,15,184,32,13,241,209,193,225,241,201,241,209,193,225,241,47,201,122,179,254,255,40,17,241,203,0,203,0,203,
  0,203,0,230,15,176,205,40,4,24,221,241,230,240,176,205,40,4,24,218,65,60,79,62,7,168,60,71,197,205,34,4,
  71,26,205,225,8,13,40,3,15,24,250,79,58,44,249,161,79,120,177,205,40,4,35,19,193,16,225,201,71,82,80,80,
  82,84,0,58,175,252,254,5,201,245,205,136,9,11,12,120,65,79,12,241,243,211,152,16,252,13,32,249,251,201,205,148,
  9,124,230,63,211,153,251,201,205,148,9,124,230,63,246,64,211,153,251,201,58,246,250,183,40,16,58,175,252,254,5,218,
  66,4,254,7,58,246,250,56,1,135,229,230,3,15,111,230,128,172,23,203,21,23,125,23,243,211,153,62,142,211,153,225,
  125,211,153,201,205,126,9,219,152,201,245,205,136,9,241,211,152,201,243,211,153,62,143,211,153,219,153,245,175,211,153,62,
  143,211,153,251,241,201,219,153,1,0,0,205,255,3,1,1,224,205,255,3,1,2,0,205,255,3,1,3,128,205,255,3,
  1,4,1,205,255,3,1,8,8,205,255,3,62,1,50,220,243,50,221,243,205,158,12,62,0,33,0,8,1,0,8,205,
  86,4,62,245,33,0,32,1,32,0,205,86,4,1,7,245,205,255,3,33,191,27,17,0,8,1,0,8,253,42,192,252,
  221,33,92,0,205,197,2,251,201,1,20,0,205,255,3,1,21,59,205,255,3,1,22,5,205,255,3,201,33,191,27,237,
  91,36,249,1,0,8,253,42,192,252,221,33,92,0,205,197,2,251,201,205,231,3,62,4,50,175,252,205,28,5,42,199,
  243,34,34,249,205,66,4,6,3,175,243,211,152,60,32,251,16,249,251,42,203,243,34,36,249,42,205,243,34,40,249,42,
  207,243,34,38,249,58,223,243,230,241,246,4,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,1,14,0,205,
  255,3,17,199,243,14,2,175,205,227,7,62,127,205,227,7,62,3,205,227,7,17,251,10,62,3,205,227,7,17,207,243,
  175,205,227,7,33,233,255,54,0,35,54,0,205,155,5,1,14,0,205,255,3,205,189,12,195,206,4,0,30,205,231,3,
  62,5,50,175,252,205,28,5,58,223,243,230,241,246,6,71,14,0,205,255,3,58,224,243,230,231,246,32,71,12,205,255,
  3,33,0,0,34,34,249,33,0,120,34,38,249,33,0,118,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,
  1,5,239,205,255,3,1,11,0,205,255,3,1,6,15,205,255,3,205,151,5,205,231,12,195,206,4,205,231,3,62,6,
  50,175,252,205,28,5,58,223,243,230,241,246,8,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,33,0,0,
  34,34,249,33,0,120,34,38,249,33,0,118,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,1,5,239,205,
  255,3,1,11,0,205,255,3,1,6,15,205,255,3,205,151,5,205,247,12,195,206,4,205,231,3,62,7,50,175,252,205,
  28,5,58,223,243,230,241,246,10,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,33,0,0,34,34,249,33,
  0,240,34,38,249,33,0,250,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,1,5,247,205,255,3,1,11,
  1,205,255,3,1,6,30,205,255,3,205,151,5,205,10,13,195,206,4,205,231,3,62,8,50,175,252,205,28,5,58,223,
  243,246,14,71,14,0,205,255,3,58,224,243,230,231,71,12,205,255,3,33,0,0,34,34,249,33,0,240,34,38,249,33,
  0,250,34,40,249,175,50,245,250,50,246,250,1,2,31,205,255,3,1,5,247,205,255,3,1,11,1,205,255,3,1,6,
  30,205,255,3,205,151,5,205,26,13,195,206,4,192,58,175,252,254,9,208,229,33,125,12,205,0,2,225,201,143,12,158,
  12,189,12,211,12,189,12,231,12,247,12,10,13,26,13,58,176,243,254,40,1,192,3,56,8,1,128,7,24,3,1,0,
  3,42,34,249,62,32,205,86,4,33,1,1,34,220,243,125,33,178,251,119,17,179,251,1,23,0,237,176,201,175,1,0,
  24,42,36,249,111,197,205,86,4,193,58,234,243,42,201,243,195,86,4,58,234,243,230,15,71,7,7,7,7,176,1,0,
  8,42,36,249,195,86,4,58,234,243,230,15,71,7,7,7,7,176,33,0,1,24,41,58,234,243,230,3,71,7,7,176,
  7,7,7,7,176,33,0,2,24,22,58,234,243,230,15,71,7,7,7,7,176,33,0,2,24,6,58,234,243,33,0,1,
  245,205,108,13,241,14,44,205,98,13,14,40,205,92,13,33,212,0,14,42,205,92,13,33,0,0,14,36,205,92,13,58,
  246,250,103,46,0,14,38,205,92,13,62,0,14,45,205,98,13,62,192,14,46,205,98,13,205,108,13,201,125,205,98,13,
  12,124,243,211,153,121,246,128,211,153,251,201,62,2,205,210,9,31,56,248,201,237,75,32,249,111,38,0,41,41,41,9,
  6,8,17,64,252,197,213,229,58,31,249,205,80,2,225,209,193,18,19,35,16,239,201,229,245,33,162,13,205,22,2,241,
  225,201,82,73,71,72,84,67,0,229,245,33,180,13,205,22,2,241,225,201,76,69,70,84,67,0,229,245,33,197,13,205,
  22,2,241,225,201,85,80,67,0,229,245,33,212,13,205,22,2,241,225,201,84,85,80,67,0,229,245,33,228,13,205,22,
  2,241,225,201,68,79,87,78,67,0,229,245,33,245,13,205,22,2,241,225,201,84,68,79,87,78,67,0,237,75,183,252,
  237,91,185,252,201,83,67,65,76,88,89,0,197,237,67,183,252,237,83,185,252,42,185,252,41,41,41,41,41,46,0,6,
  0,62,255,50,44,249,121,230,7,40,10,71,62,255,167,31,16,252,50,44,249,121,230,248,79,6,0,9,34,42,249,193,
  201,77,65,80,88,89,0,58,44,249,42,42,249,201,70,69,84,67,72,67,0,229,245,33,96,14,205,22,2,241,225,201,
  83,84,79,82,69,67,0,229,245,33,114,14,205,22,2,241,225,201,83,69,84,65,84,82,0,229,245,33,132,14,205,22,
  2,241,225,201,82,69,65,68,67,0,229,245,33,149,14,205,22,2,241,225,201,83,69,84,67,0,229,245,33,165,14,205,
  22,2,241,225,201,78,83,69,84,67,88,0,229,245,33,183,14,205,22,2,241,225,201,71,84,65,83,80,67,0,229,245,
  33,201,14,205,22,2,241,225,201,80,78,84,73,78,73,0,229,245,33,219,14,205,22,2,241,225,201,83,67,65,78,82,
  0,229,245,33,236,14,205,22,2,241,225,201,83,67,65,78,76,0,229,245,33,253,14,205,22,2,241,225,201,68,79,71,
  82,80,72,0,197,213,229,205,117,13,58,233,243,50,242,243,42,183,252,34,102,245,1,8,0,9,34,183,252,58,246,250,
  42,185,252,103,34,104,245,237,67,106,245,237,67,108,245,33,64,252,203,6,58,242,243,56,3,58,234,243,50,110,245,205,
  194,17,58,2,251,230,15,246,176,237,121,62,172,211,153,62,145,211,153,251,6,8,14,7,33,64,252,203,6,58,242,243,
  56,3,58,234,243,211,155,13,32,241,35,14,8,16,236,225,209,193,201,229,245,33,126,15,205,22,2,241,225,201,77,65,
  80,88,89,67,0,229,245,33,144,15,205,22,2,241,225,201,84,82,73,71,72,84,0,229,245,33,162,15,205,22,2,241,
  225,201,84,82,73,71,72,84,0,58,246,250,87,213,237,67,102,245,237,83,104,245,42,179,252,167,237,66,34,106,245,33,
  0,0,34,108,245,175,50,111,245,58,242,243,50,110,245,205,253,15,42,181,252,58,246,250,103,34,104,245,205,253,15,209,
  237,83,104,245,62,1,50,111,245,58,181,252,147,50,106,245,205,253,15,42,179,252,34,102,245,205,253,15,201,205,194,17,
  58,2,251,230,15,246,112,237,121,251,201,42,181,252,231,48,1,235,167,237,82,35,34,108,245,58,246,250,87,237,83,104,
  245,197,209,42,179,252,231,48,1,235,167,237,82,35,34,106,245,237,83,102,245,175,50,111,245,58,242,243,50,110,245,205,
  194,17,58,2,251,230,15,246,128,237,121,251,201,229,245,33,90,16,205,22,2,241,225,195,110,12,67,76,82,84,88,84,
  0,229,213,197,42,34,249,203,4,203,4,58,245,250,15,15,15,132,246,31,71,14,2,205,255,3,58,175,252,254,7,32,
  19,58,229,243,230,31,71,58,245,250,15,15,15,176,71,14,6,205,255,3,58,245,250,79,58,175,252,254,7,32,2,203,
  33,175,42,40,249,41,143,177,111,62,3,180,71,14,5,205,255,3,69,14,11,205,255,3,193,209,225,201,229,205,39,17,
  205,136,9,1,16,0,205,255,3,6,32,33,92,17,126,211,152,35,211,154,16,248,225,201,229,205,39,17,205,126,9,225,
  1,16,0,205,255,3,6,32,219,152,211,154,16,250,201,229,245,205,39,17,241,135,79,6,0,9,205,126,9,219,152,71,
  219,152,79,225,201,245,197,229,205,39,17,122,135,79,6,0,9,205,136,9,225,66,14,16,205,255,3,193,241,211,154,211,
  152,123,211,154,211,152,201,58,175,252,183,204,62,17,60,33,72,17,135,133,111,124,206,0,103,126,35,102,111,201,103,58,
  176,243,254,40,124,208,61,201,0,4,0,15,32,32,128,27,32,32,128,27,128,118,128,118,128,250,128,250,0,0,0,0,
  17,6,51,7,23,1,39,3,81,1,39,6,113,1,115,3,97,6,100,6,17,4,101,2,85,5,119,7,229,245,33,135,
  17,205,22,2,241,225,201,66,69,69,80,0,229,245,33,151,17,205,22,2,241,225,201,80,82,79,77,80,84,0,229,245,
  33,169,17,205,22,2,241,225,201,83,68,70,83,67,82,0,229,245,33,187,17,205,22,2,241,225,201,83,69,84,83,67,
  82,0,62,2,205,210,9,31,56,248,243,62,32,211,153,62,145,211,153,1,155,14,33,98,245,237,179,201,120,177,55,200,
  122,179,55,200,229,33,0,1,58,175,252,230,6,254,6,58,175,252,32,1,36,183,237,66,225,216,229,33,212,0,183,237,
  82,225,201,237,75,106,245,237,91,108,245,205,220,17,216,205,194,17,126,230,15,246,144,237,121,251,183,201,42,98,245,78,
  35,70,35,237,67,106,245,94,35,86,35,237,83,108,245,205,220,17,216,254,8,17,4,1,40,10,254,6,17,1,4,40,
  3,17,2,2,78,175,67,203,17,23,203,17,23,16,248,50,110,245,66,5,197,229,205,194,17,126,230,15,246,176,237,121,
  62,172,211,153,62,145,211,153,251,225,193,62,2,205,210,9,203,71,200,203,127,40,244,120,167,40,18,197,175,67,203,17,
  23,203,17,23,16,248,211,155,121,193,79,16,238,35,78,66,24,217,42,102,245,237,75,106,245,237,91,108,245,113,35,112,
  35,115,35,114,35,205,220,17,216,254,8,17,1,1,40,10,254,6,17,2,4,40,3,17,4,2,229,205,194,17,126,230,
  15,62,160,237,121,251,225,66,14,0,62,2,205,210,9,203,127,32,4,203,71,32,243,197,62,7,205,210,9,67,203,1,
  16,252,177,193,79,16,227,113,35,62,2,205,210,9,31,56,214,201,229,245,33,253,18,205,22,2,241,225,201,66,76,84,
  86,68,0,229,245,33,14,19,205,22,2,241,225,201,66,76,84,68,86,0,229,245,33,31,19,205,22,2,241,225,201,66,
  76,84,77,68,0,229,245,33,48,19,205,22,2,241,225,201,66,76,84,68,77,0,229,245,33,65,19,205,22,2,241,225,
  201,78,69,87,80,65,68,0,205,179,4,205,188,16,201,229,245,33,90,19,205,22,2,241,225,201,75,78,74,80,82,84,
  0,197,62,13,211,180,121,15,15,15,15,230,3,71,219,181,176,193,211,181,121,230,15,211,180,219,181,230,15,201,197,71,
  197,62,13,211,180,121,15,15,15,15,230,3,71,219,181,176,193,211,181,121,230,15,211,180,120,230,15,211,181,193,201,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
}
namespace Nintendo64 {
namespace PIF {
const unsigned char ROM[1984] = {
  60,9,52,0,64,137,96,0,60,9,0,6,53,41,228,99,64,137,128,0,60,8,164,4,141,8,0,16,49,8,0,1,
  81,0,255,253,60,8,164,4,36,8,0,10,60,1,164,4,172,40,0,16,60,8,164,4,141,8,0,24,49,8,0,1,
  85,0,255,253,60,8,164,4,36,8,0,3,60,1,164,96,172,40,0,16,36,8,3,255,60,1,164,64,172,40,0,12,
  60,1,164,64,172,32,0,36,60,1,164,64,172,32,0,16,60,1,164,80,172,32,0,0,60,1,164,80,172,32,0,4,
  60,8,164,4,141,8,0,16,49,8,0,4,85,0,255,253,60,8,164,4,60,11,164,0,60,12,191,192,60,13,191,192,
  37,107,16,0,37,140,0,212,37,173,7,28,141,137,0,0,37,140,0,4,37,107,0,4,21,141,255,252,173,105,255,252,
  60,11,164,0,60,29,164,0,37,107,16,0,1,96,0,8,55,189,31,240,60,13,191,192,141,168,7,252,37,173,7,192,
  49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,0,8,156,194,50,115,0,1,0,8,188,130,
  18,96,0,2,50,247,0,1,60,11,166,0,0,8,178,2,49,10,0,255,0,8,172,66,141,168,0,60,36,9,0,16,
  50,214,0,255,50,181,0,1,36,20,0,1,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,173,136,0,24,36,8,0,15,173,136,0,28,
  36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,49,40,0,255,173,136,0,20,0,9,66,2,
  173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,141,175,0,12,32,8,15,192,33,107,0,64,
  49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,37,173,0,12,49,239,0,32,85,224,255,252,
  60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,141,105,0,0,33,8,255,252,33,107,0,4,
  33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,1,72,0,25,0,0,32,18,36,132,0,1,
  60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,20,160,0,2,175,191,0,28,0,192,40,37,
  39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,1,196,16,35,20,64,0,2,0,64,24,37,
  0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,0,0,0,0,39,189,255,32,175,191,0,60,
  175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,175,178,0,32,175,177,0,28,175,176,0,24,
  140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,36,66,0,16,172,80,255,244,172,80,255,248,
  172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,0,160,176,37,36,23,0,32,2,0,160,37,
  142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,1,241,32,35,2,32,48,37,4,17,255,204,
  2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,175,163,0,116,4,17,255,197,2,32,48,37,
  143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,52,165,137,101,38,4,0,5,4,17,255,188,
  2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,175,169,0,128,143,164,0,152,2,0,40,37,
  4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,1,80,88,33,175,171,0,152,50,130,0,31,
  143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,0,112,200,6,0,80,192,4,1,213,120,33,
  175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,143,163,0,140,175,162,0,144,2,3,8,43,
  80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,1,42,24,38,16,0,0,5,175,163,0,140,
  143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,143,175,0,136,2,226,24,35,0,112,112,6,
  0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,175,184,0,136,3,40,40,37,143,164,0,148,
  4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,143,164,0,176,2,64,40,37,4,17,255,124,
  2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,1,43,40,37,0,64,32,37,4,17,255,116,
  2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,2,32,48,37,50,18,0,31,2,242,160,35,
  2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,2,32,48,37,143,169,0,168,50,99,0,31,
  2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,0,115,192,6,143,173,0,156,3,8,80,37,
  1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,2,32,48,37,4,17,255,85,1,176,32,33,
  143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,1,208,32,38,143,175,0,148,143,184,0,164,
  175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,143,163,0,116,0,0,136,37,39,179,0,116,
  36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,175,163,0,112,142,112,0,0,143,173,0,100,
  50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,1,172,112,33,2,14,8,43,16,32,0,5,
  175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,143,164,0,104,2,0,40,37,4,17,255,44,
  2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,85,18,0,6,143,164,0,108,143,171,0,108,
  1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,4,17,255,30,2,32,48,37,175,162,0,108,
  86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,175,173,0,112,143,164,0,112,2,0,40,37,
  4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,38,115,0,4,143,164,0,100,143,165,0,104,
  4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,143,177,0,28,143,178,0,32,143,179,0,36,
  143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,0,64,32,37,39,189,0,224,4,17,0,8,
  1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,172,239,0,0,3,224,0,8,0,0,0,0,
  60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,0,136,32,37,37,107,7,192,60,9,164,128,
  141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,141,104,0,60,
  36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,141,104,0,60,49,10,0,128,80,10,255,250,
  32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,0,0,0,0,0,0,0,0,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char NTSC[1984] = {
  60,13,191,192,141,168,7,252,37,173,7,192,49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,
  0,8,156,194,50,115,0,1,0,8,188,130,18,96,0,2,50,247,0,1,60,11,166,0,0,8,178,2,49,10,0,255,
  0,8,172,66,141,168,0,60,36,9,0,16,50,214,0,255,50,181,0,1,36,20,0,1,1,9,64,37,60,9,164,128,
  141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,
  173,136,0,24,36,8,0,15,173,136,0,28,36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,
  49,40,0,255,173,136,0,20,0,9,66,2,173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,
  141,175,0,12,32,8,15,192,33,107,0,64,49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,
  37,173,0,12,49,239,0,32,85,224,255,252,60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,
  141,105,0,0,33,8,255,252,33,107,0,4,33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,
  1,72,0,25,0,0,32,18,36,132,0,1,60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,
  20,160,0,2,175,191,0,28,0,192,40,37,39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,
  1,196,16,35,20,64,0,2,0,64,24,37,0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,
  0,0,0,0,39,189,255,32,175,191,0,60,175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,
  175,178,0,32,175,177,0,28,175,176,0,24,140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,
  36,66,0,16,172,80,255,244,172,80,255,248,172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,
  0,160,176,37,36,23,0,32,2,0,160,37,142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,
  1,241,32,35,2,32,48,37,4,17,255,204,2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,
  175,163,0,116,4,17,255,197,2,32,48,37,143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,
  52,165,137,101,38,4,0,5,4,17,255,188,2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,
  175,169,0,128,143,164,0,152,2,0,40,37,4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,
  1,80,88,33,175,171,0,152,50,130,0,31,143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,
  0,112,200,6,0,80,192,4,1,213,120,33,175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,
  143,163,0,140,175,162,0,144,2,3,8,43,80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,
  1,42,24,38,16,0,0,5,175,163,0,140,143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,
  143,175,0,136,2,226,24,35,0,112,112,6,0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,
  175,184,0,136,3,40,40,37,143,164,0,148,4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,
  143,164,0,176,2,64,40,37,4,17,255,124,2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,
  1,43,40,37,0,64,32,37,4,17,255,116,2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,
  2,32,48,37,50,18,0,31,2,242,160,35,2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,
  2,32,48,37,143,169,0,168,50,99,0,31,2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,
  0,115,192,6,143,173,0,156,3,8,80,37,1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,
  2,32,48,37,4,17,255,85,1,176,32,33,143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,
  1,208,32,38,143,175,0,148,143,184,0,164,175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,
  143,163,0,116,0,0,136,37,39,179,0,116,36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,
  175,163,0,112,142,112,0,0,143,173,0,100,50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,
  1,172,112,33,2,14,8,43,16,32,0,5,175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,
  143,164,0,104,2,0,40,37,4,17,255,44,2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,
  85,18,0,6,143,164,0,108,143,171,0,108,1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,
  4,17,255,30,2,32,48,37,175,162,0,108,86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,
  175,173,0,112,143,164,0,112,2,0,40,37,4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,
  38,115,0,4,143,164,0,100,143,165,0,104,4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,
  143,177,0,28,143,178,0,32,143,179,0,36,143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,
  0,64,32,37,39,189,0,224,4,17,0,8,1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,
  172,239,0,0,3,224,0,8,0,0,0,0,60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,
  0,136,32,37,37,107,7,192,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,
  85,32,255,253,60,9,164,128,141,104,0,60,36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,
  49,41,0,2,85,32,255,253,60,9,164,128,173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,
  141,104,0,60,49,10,0,128,80,10,255,250,32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,
  49,41,0,2,85,32,255,253,60,9,164,128,173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char PAL[1984] = {
  60,9,52,0,64,137,96,0,60,9,0,6,53,41,228,99,64,137,128,0,60,8,164,4,141,8,0,16,49,8,0,1,
  81,0,255,253,60,8,164,4,36,8,0,10,60,1,164,4,172,40,0,16,60,8,164,4,141,8,0,24,49,8,0,1,
  85,0,255,253,60,8,164,4,36,8,0,3,60,1,164,96,172,40,0,16,36,8,3,255,60,1,164,64,172,40,0,12,
  60,1,164,64,172,32,0,36,60,1,164,64,172,32,0,16,60,1,164,80,172,32,0,0,60,1,164,80,172,32,0,4,
  60,8,164,4,141,8,0,16,49,8,0,4,85,0,255,253,60,8,164,4,60,11,164,0,60,12,191,192,60,13,191,192,
  37,107,16,0,37,140,0,212,37,173,7,32,141,137,0,0,37,140,0,4,37,107,0,4,21,141,255,252,173,105,255,252,
  60,11,164,0,60,29,164,0,37,107,16,0,1,96,0,8,55,189,31,240,60,13,191,192,141,168,7,252,37,173,7,192,
  49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,0,8,188,130,0,8,156,194,50,247,0,1,
  50,115,0,1,18,96,0,2,54,247,0,6,60,11,166,0,0,8,178,2,49,10,0,255,0,8,172,66,141,168,0,60,
  36,9,0,16,50,214,0,255,50,181,0,1,36,20,0,0,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,
  85,32,255,253,60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,173,136,0,24,36,8,0,15,
  173,136,0,28,36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,49,40,0,255,173,136,0,20,
  0,9,66,2,173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,141,175,0,12,32,8,15,192,
  33,107,0,64,49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,37,173,0,12,49,239,0,32,
  85,224,255,252,60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,141,105,0,0,33,8,255,252,
  33,107,0,4,33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,1,72,0,25,0,0,32,18,
  36,132,0,1,60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,20,160,0,2,175,191,0,28,
  0,192,40,37,39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,1,196,16,35,20,64,0,2,
  0,64,24,37,0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,0,0,0,0,39,189,255,32,
  175,191,0,60,175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,175,178,0,32,175,177,0,28,
  175,176,0,24,140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,36,66,0,16,172,80,255,244,
  172,80,255,248,172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,0,160,176,37,36,23,0,32,
  2,0,160,37,142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,1,241,32,35,2,32,48,37,
  4,17,255,204,2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,175,163,0,116,4,17,255,197,
  2,32,48,37,143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,52,165,137,101,38,4,0,5,
  4,17,255,188,2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,175,169,0,128,143,164,0,152,
  2,0,40,37,4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,1,80,88,33,175,171,0,152,
  50,130,0,31,143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,0,112,200,6,0,80,192,4,
  1,213,120,33,175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,143,163,0,140,175,162,0,144,
  2,3,8,43,80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,1,42,24,38,16,0,0,5,
  175,163,0,140,143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,143,175,0,136,2,226,24,35,
  0,112,112,6,0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,175,184,0,136,3,40,40,37,
  143,164,0,148,4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,143,164,0,176,2,64,40,37,
  4,17,255,124,2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,1,43,40,37,0,64,32,37,
  4,17,255,116,2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,2,32,48,37,50,18,0,31,
  2,242,160,35,2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,2,32,48,37,143,169,0,168,
  50,99,0,31,2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,0,115,192,6,143,173,0,156,
  3,8,80,37,1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,2,32,48,37,4,17,255,85,
  1,176,32,33,143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,1,208,32,38,143,175,0,148,
  143,184,0,164,175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,143,163,0,116,0,0,136,37,
  39,179,0,116,36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,175,163,0,112,142,112,0,0,
  143,173,0,100,50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,1,172,112,33,2,14,8,43,
  16,32,0,5,175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,143,164,0,104,2,0,40,37,
  4,17,255,44,2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,85,18,0,6,143,164,0,108,
  143,171,0,108,1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,4,17,255,30,2,32,48,37,
  175,162,0,108,86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,175,173,0,112,143,164,0,112,
  2,0,40,37,4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,38,115,0,4,143,164,0,100,
  143,165,0,104,4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,143,177,0,28,143,178,0,32,
  143,179,0,36,143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,0,64,32,37,39,189,0,224,
  4,17,0,8,1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,172,239,0,0,3,224,0,8,
  0,0,0,0,60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,0,136,32,37,37,107,7,192,
  60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  141,104,0,60,36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,141,104,0,60,49,10,0,128,
  80,10,255,250,32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,0,0,0,0,0,0,0,0,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
}
}
namespace SuperFamicom {
const unsigned char Boards[31960] = {
  100,97,116,97,98,97,115,101,10,32,32,114,101,118,105,115,105,111,110,58,32,50,48,50,48,45,48,54,45,48,55,10,
  10,47,47,66,111,97,114,100,115,32,40,80,114,111,100,117,99,116,105,111,110,41,10,10,100,97,116,97,98,97,115,101,
  10,32,32,114,101,118,105,115,105,111,110,58,32,50,48,50,48,45,48,49,45,50,49,10,10,98,111,97,114,100,58,32,
  66,65,78,68,65,73,45,80,84,45,57,50,51,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,
  99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,
  48,10,32,32,115,108,111,116,32,116,121,112,101,61,83,117,102,97,109,105,84,117,114,98,111,10,32,32,32,32,114,111,
  109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,
  56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,114,97,109,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,54,102,44,101,48,45,101,102,58,48,48,48,48,
  45,102,102,102,102,10,32,32,115,108,111,116,32,116,121,112,101,61,83,117,102,97,109,105,84,117,114,98,111,10,32,32,
  32,32,114,111,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,44,99,48,
  45,100,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,114,97,
  109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,
  48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,66,83,67,45,49,65,53,66,57,80,45,48,49,10,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,49,48,45,49,55,58,53,48,48,48,45,53,102,102,102,32,109,
  97,115,107,61,48,120,102,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,
  114,61,77,67,67,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,48,102,58,53,48,48,48,
  45,53,102,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,
  45,55,102,102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,
  101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,
  77,32,99,111,110,116,101,110,116,61,68,111,119,110,108,111,97,100,10,32,32,32,32,32,32,115,108,111,116,32,116,121,
  112,101,61,66,83,77,101,109,111,114,121,10,10,98,111,97,114,100,58,32,66,83,67,45,49,65,53,77,45,48,50,10,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,
  109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,58,56,48,48,48,45,102,102,102,
  102,32,109,97,115,107,61,48,120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,48,48,48,48,48,48,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,49,48,48,48,48,48,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,
  120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,50,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,
  48,48,48,32,98,97,115,101,61,48,120,49,48,48,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,
  48,48,10,32,32,115,108,111,116,32,116,121,112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,99,48,45,101,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,
  66,83,67,45,49,65,55,77,45,40,48,49,44,49,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,49,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,48,48,48,
  32,98,97,115,101,61,48,120,48,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,
  48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,48,48,48,32,98,97,115,
  101,61,48,120,49,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,56,48,45,57,102,
  58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,
  50,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,97,48,45,98,102,58,56,48,48,
  48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,49,48,48,48,
  48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,
  101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,
  48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,115,108,111,116,32,116,121,112,101,61,
  66,83,77,101,109,111,114,121,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,101,102,58,48,
  48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,66,83,67,45,49,74,51,77,45,48,49,10,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,
  102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,44,99,48,45,100,102,
  58,48,48,48,48,45,102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,
  116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,
  97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,115,108,
  111,116,32,116,121,112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,50,48,45,51,102,44,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,54,48,45,55,100,44,101,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,
  97,114,100,58,32,66,83,67,45,49,74,53,77,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,52,48,45,53,102,44,99,48,45,100,102,58,48,48,48,48,45,102,102,102,102,10,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,
  102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,115,108,111,116,32,116,121,112,101,61,66,83,77,101,
  109,111,114,121,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,
  58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,55,100,
  44,101,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,66,83,67,45,49,76,51,
  66,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,87,54,
  53,67,56,49,54,83,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,50,50,48,48,45,50,51,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,
  107,61,48,120,52,48,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,
  102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,115,108,111,116,32,116,121,
  112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,
  48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,
  10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,52,102,58,48,48,48,48,45,102,102,
  102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,73,
  110,116,101,114,110,97,108,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,
  56,48,45,98,102,58,51,48,48,48,45,51,55,102,102,32,115,105,122,101,61,48,120,56,48,48,10,10,98,111,97,114,
  100,58,32,66,83,67,45,49,76,53,66,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,
  116,101,99,116,117,114,101,61,87,54,53,67,56,49,54,83,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,48,48,45,51,102,44,56,48,45,98,102,58,50,50,48,48,45,50,51,102,102,10,32,32,32,32,109,99,117,10,32,
  32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,
  48,45,102,102,102,102,32,109,97,115,107,61,48,120,52,48,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,
  32,32,32,115,108,111,116,32,116,121,112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,
  105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,
  52,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,
  32,99,111,110,116,101,110,116,61,73,110,116,101,114,110,97,108,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,55,102,102,32,115,105,122,101,61,48,
  120,56,48,48,10,10,98,111,97,114,100,58,32,83,71,66,45,82,45,49,48,10,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,
  99,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,112,114,
  111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,73,67,68,32,114,101,118,105,115,105,111,110,61,
  50,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,
  48,48,45,54,55,102,102,44,55,48,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,79,77,32,99,111,110,116,101,110,116,61,66,111,111,116,32,97,114,99,104,105,116,101,99,116,117,114,101,61,
  83,77,56,51,10,32,32,32,32,115,108,111,116,32,116,121,112,101,61,71,97,109,101,66,111,121,10,10,98,111,97,114,
  100,58,32,83,72,86,67,45,49,65,48,78,45,40,48,49,44,48,50,44,49,48,44,50,48,44,51,48,41,10,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,
  48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,65,49,66,45,40,48,52,44,48,53,44,48,54,41,
  10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,
  97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,
  48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,
  112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,
  58,32,83,72,86,67,45,49,65,49,77,45,40,48,49,44,49,48,44,49,49,44,50,48,41,10,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,
  102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,
  55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,
  98,111,97,114,100,58,32,83,72,86,67,45,49,65,51,66,45,40,49,49,44,49,50,44,49,51,41,10,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,
  102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,
  77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,
  48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,
  67,45,49,65,51,66,45,50,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,
  101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,
  100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,
  102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,65,51,77,
  45,40,49,48,44,50,48,44,50,49,44,51,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,
  48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,
  101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,
  48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,
  45,49,65,53,66,45,40,48,50,44,48,52,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,
  99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,
  48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,
  10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,
  48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,65,53,77,45,40,48,49,44,49,49,44,
  50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,
  102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,
  107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,66,48,78,45,40,48,50,44,48,
  51,44,49,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,
  80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,
  45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,
  101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,51,48,45,51,102,44,98,48,45,98,102,58,56,48,48,48,45,102,102,102,102,
  32,109,97,115,107,61,48,120,51,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,
  68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,
  116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,
  104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,
  10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,66,53,66,45,48,50,10,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,
  101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,
  48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,
  116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  50,48,45,51,102,44,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,51,102,102,
  102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,
  105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,
  80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,83,72,
  86,67,45,49,67,48,78,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,
  61,71,83,85,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,51,48,48,48,45,51,52,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,
  111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,
  48,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,
  97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,55,100,44,101,48,45,102,
  102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,67,48,78,53,83,45,
  48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,71,83,85,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,
  45,51,52,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,
  116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,
  102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,
  32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,55,100,44,101,48,45,102,102,58,48,48,48,
  48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,67,65,48,78,53,83,45,48,49,10,32,
  32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,71,83,85,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,52,102,
  102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,44,99,48,45,100,102,58,48,48,48,48,45,102,102,102,
  102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,
  118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,55,48,45,55,49,44,102,48,45,102,49,58,48,48,48,48,45,102,102,102,102,10,10,
  98,111,97,114,100,58,32,83,72,86,67,45,49,67,65,48,78,54,83,45,48,49,10,32,32,112,114,111,99,101,115,115,
  111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,71,83,85,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,52,102,102,10,32,32,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,52,48,45,53,102,44,99,48,45,100,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,
  102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,55,48,45,55,49,44,102,48,45,102,49,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,
  72,86,67,45,49,67,65,54,66,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,
  99,116,117,114,101,61,71,83,85,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,
  56,48,45,98,102,58,51,48,48,48,45,51,52,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,
  61,48,120,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,44,
  99,48,45,100,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,
  50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,49,44,102,48,45,
  102,49,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,67,66,48,78,55,
  83,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,71,83,
  85,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,
  48,48,45,51,52,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,
  101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,
  45,51,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,
  55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,55,48,45,55,49,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,45,
  49,67,66,53,66,45,40,48,49,44,50,48,41,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,
  101,99,116,117,114,101,61,71,83,85,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,
  44,56,48,45,98,102,58,51,48,48,48,45,51,52,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,
  48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,58,48,48,48,48,45,
  102,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,
  61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,49,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,
  114,100,58,32,83,72,86,67,45,49,67,66,55,66,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,
  99,104,105,116,101,99,116,117,114,101,61,71,83,85,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,
  48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,52,102,102,10,32,32,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,53,102,58,48,
  48,48,48,45,102,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,
  116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,
  102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,49,58,48,48,48,48,45,102,102,102,102,10,
  10,98,111,97,114,100,58,32,83,72,86,67,45,49,68,67,48,78,45,48,49,10,32,32,112,114,111,99,101,115,115,111,
  114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,83,49,54,57,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,99,48,48,45,54,102,102,102,44,55,
  99,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,
  116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,
  48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,
  10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,
  101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,55,58,48,48,48,48,45,55,
  102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,
  68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,83,49,54,57,10,32,32,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,
  104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,83,49,54,57,10,32,32,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,54,98,102,102,44,55,48,48,48,
  45,55,98,102,102,32,109,97,115,107,61,48,120,102,48,48,48,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,
  10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,68,83,48,66,45,50,48,10,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,
  97,115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,
  117,114,101,61,117,80,68,57,54,48,53,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,
  54,55,44,101,48,45,101,55,58,48,48,48,48,45,51,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,
  112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,
  117,114,101,61,117,80,68,57,54,48,53,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,57,54,
  48,53,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,
  68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,57,54,48,53,48,10,32,32,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,54,56,45,54,102,44,101,56,45,101,102,58,48,48,48,48,45,55,102,
  102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,
  111,97,114,100,58,32,83,72,86,67,45,49,74,48,78,45,40,48,49,44,49,48,44,50,48,41,10,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,
  102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,
  48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,74,49,77,45,40,49,49,44,50,
  48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,
  103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,
  44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,
  48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,74,51,66,45,48,49,10,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,
  102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,
  97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,
  54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,114,100,58,32,83,72,
  86,67,45,49,74,51,77,45,40,48,49,44,49,49,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,
  10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,
  45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,
  74,53,77,45,40,48,49,44,49,49,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,
  102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,75,48,78,45,
  48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,
  103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,
  44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,
  104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,48,48,45,49,102,44,56,48,45,57,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,102,
  102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,
  114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,
  104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,
  117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,83,
  72,86,67,45,49,75,49,66,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,
  110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,
  45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,
  97,115,107,61,48,120,101,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,
  117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,
  102,44,56,48,45,57,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,102,102,102,10,32,32,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,
  32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,
  117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,
  53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,75,
  49,88,45,49,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,
  80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,
  45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,
  101,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,
  68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,
  102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,102,102,102,10,32,32,32,32,109,101,109,111,114,
  121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,
  116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,
  68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,
  116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,
  111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,76,48,78,51,83,45,48,
  49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,87,54,53,67,56,
  49,54,83,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,
  50,50,48,48,45,50,51,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,
  120,52,48,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,
  48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,
  99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,
  50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,52,102,58,48,48,48,
  48,45,102,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,
  110,116,61,73,110,116,101,114,110,97,108,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,
  45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,55,102,102,32,115,105,122,101,61,48,120,56,48,48,10,10,
  98,111,97,114,100,58,32,83,72,86,67,45,49,76,51,66,45,40,48,50,44,49,49,41,10,32,32,112,114,111,99,101,
  115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,87,54,53,67,56,49,54,83,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,50,50,48,48,45,50,51,102,102,
  10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,
  44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,52,48,56,48,48,48,10,32,
  32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,
  10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,
  114,111,103,114,97,109,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,
  110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,
  56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,52,102,58,48,48,48,48,45,102,102,102,102,10,32,32,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,73,110,116,101,114,110,
  97,108,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,51,48,48,48,45,51,55,102,102,32,115,105,122,101,61,48,120,56,48,48,10,10,98,111,97,114,100,58,32,83,72,
  86,67,45,49,76,53,66,45,40,49,49,44,50,48,41,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,
  105,116,101,99,116,117,114,101,61,87,54,53,67,56,49,54,83,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,48,48,45,51,102,44,56,48,45,98,102,58,50,50,48,48,45,50,51,102,102,10,32,32,32,32,109,99,117,10,
  32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,
  48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,52,48,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,
  32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,
  48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,52,48,45,52,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,73,110,116,101,114,110,97,108,10,32,32,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,55,102,
  102,32,115,105,122,101,61,48,120,56,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,49,78,48,78,45,40,
  48,49,44,49,48,41,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,83,68,
  68,49,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,52,
  56,48,48,45,52,56,48,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,
  10,10,98,111,97,114,100,58,32,83,72,86,67,45,50,65,48,78,45,48,49,35,65,10,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,48,48,45,50,102,44,56,48,45,97,102,58,56,48,48,48,45,102,102,102,102,32,
  109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,54,
  102,44,99,48,45,101,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,
  111,97,114,100,58,32,83,72,86,67,45,50,65,48,78,45,40,48,49,44,49,48,44,49,49,44,50,48,41,10,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,
  48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,50,65,49,77,45,48,49,10,32,32,109,101,109,111,114,
  121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,
  32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,
  111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,
  100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,
  111,97,114,100,58,32,83,72,86,67,45,50,65,51,66,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,
  61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,
  102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,
  83,72,86,67,45,50,65,51,77,45,48,49,35,65,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,
  48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,
  101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,
  48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,
  45,50,65,51,77,45,40,48,49,44,49,49,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,
  56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,
  97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,
  48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,
  86,67,45,50,65,53,77,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,
  116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,
  55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,
  102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,50,66,51,
  66,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,
  114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,
  121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,
  115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,
  114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,54,102,
  44,101,48,45,101,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,51,102,102,102,10,32,32,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,
  32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,
  117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,
  53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,83,72,86,67,45,50,68,
  67,48,78,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,
  72,71,53,49,66,83,49,54,57,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,
  56,48,45,98,102,58,54,99,48,48,45,54,102,102,102,44,55,99,48,48,45,55,102,102,102,10,32,32,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,55,48,45,55,55,58,48,48,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,
  114,101,61,72,71,53,49,66,83,49,54,57,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,
  32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,
  83,49,54,57,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,54,48,48,48,45,54,98,102,102,44,55,48,48,48,45,55,98,102,102,32,109,97,115,107,61,48,120,102,48,
  48,48,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,83,72,86,67,45,50,
  69,51,77,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,
  61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,
  48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,
  99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,79,66,67,49,10,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,
  107,61,48,120,101,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,49,44,102,
  48,45,102,49,58,54,48,48,48,45,55,102,102,102,44,101,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,
  101,48,48,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,
  61,83,97,118,101,10,10,98,111,97,114,100,58,32,83,72,86,67,45,50,74,48,78,45,40,48,49,44,49,48,44,49,
  49,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,
  80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,
  45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,83,72,86,67,
  45,50,74,51,77,45,40,48,49,44,49,49,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,49,48,45,49,102,44,51,48,45,51,102,44,57,48,45,57,102,44,
  98,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,
  114,100,58,32,83,72,86,67,45,50,74,53,77,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,49,48,45,49,102,44,51,48,45,51,102,44,57,48,45,57,102,44,
  98,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,
  114,100,58,32,83,72,86,67,45,51,74,48,78,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,48,48,45,50,102,44,56,48,45,97,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,52,48,45,54,102,44,99,48,45,101,102,58,48,48,48,48,45,102,102,102,102,10,10,
  98,111,97,114,100,58,32,83,72,86,67,45,66,65,48,78,45,40,48,49,44,49,48,41,10,32,32,109,101,109,111,114,
  121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,
  32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,
  55,100,44,99,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,
  98,111,97,114,100,58,32,83,72,86,67,45,66,65,49,77,45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,
  61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,
  116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,
  102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,
  32,83,72,86,67,45,66,65,51,77,45,40,48,49,44,49,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,
  61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,
  102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,
  83,72,86,67,45,66,74,48,78,45,40,48,49,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,
  10,98,111,97,114,100,58,32,83,72,86,67,45,66,74,49,77,45,40,49,48,44,50,48,41,10,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,
  102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,
  48,48,45,102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,
  116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,
  98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,114,100,58,
  32,83,72,86,67,45,66,74,51,77,45,40,49,48,44,50,48,41,10,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,
  10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,
  45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,76,
  68,72,51,67,45,48,49,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,83,
  80,67,55,49,49,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,52,56,48,48,45,52,56,51,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,53,48,44,
  53,56,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,
  107,61,48,120,56,48,48,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,
  102,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,32,32,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,
  10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,
  97,116,97,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,
  83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,114,116,99,32,109,
  97,110,117,102,97,99,116,117,114,101,114,61,69,112,115,111,110,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,48,48,45,51,102,44,56,48,45,98,102,58,52,56,52,48,45,52,56,52,50,10,32,32,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,84,67,32,99,111,110,116,101,110,116,61,84,105,109,101,32,109,97,110,117,102,97,99,
  116,117,114,101,114,61,69,112,115,111,110,10,10,98,111,97,114,100,58,32,83,72,86,67,45,76,74,51,77,45,48,49,
  10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,
  97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,58,56,48,48,48,45,102,102,
  102,102,32,98,97,115,101,61,48,120,52,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,52,48,45,55,100,58,48,48,48,48,45,102,102,102,102,32,98,97,115,101,61,48,120,52,48,48,48,48,48,10,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,
  97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,
  102,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,
  120,101,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,76,78,51,66,45,48,49,10,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,
  109,97,115,107,61,48,120,101,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,
  51,58,48,48,48,48,45,102,102,102,102,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,
  101,114,61,83,68,68,49,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,52,56,48,48,45,52,56,48,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,
  32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,10,10,98,111,97,114,100,58,32,83,72,86,67,45,83,71,66,50,45,48,49,10,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,
  102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,
  48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,
  10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,73,67,68,32,114,101,118,105,
  115,105,111,110,61,50,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,54,48,48,48,45,54,55,102,102,44,55,48,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,
  121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,66,111,111,116,32,97,114,99,104,105,116,101,99,
  116,117,114,101,61,83,77,56,51,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,32,32,32,32,115,108,111,
  116,32,116,121,112,101,61,71,97,109,101,66,111,121,10,10,98,111,97,114,100,58,32,83,72,86,67,45,89,65,48,78,
  45,48,49,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,
  102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,
  115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,83,72,86,67,45,89,74,48,78,45,48,49,10,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,
  10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,
  48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,
  102,102,58,48,48,48,48,45,102,102,102,102,10,10,47,47,66,111,97,114,100,115,32,40,71,101,110,101,114,105,99,41,
  10,10,100,97,116,97,98,97,115,101,10,32,32,114,101,118,105,115,105,111,110,58,32,50,48,50,48,45,48,54,45,48,
  55,10,10,98,111,97,114,100,58,32,65,82,77,45,76,79,82,79,77,45,82,65,77,10,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,
  109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,54,
  102,44,99,48,45,101,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,
  109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,102,102,
  102,102,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,65,82,77,54,
  10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,56,48,
  48,45,51,56,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,
  110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,65,82,77,54,10,32,32,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,
  99,104,105,116,101,99,116,117,114,101,61,65,82,77,54,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,65,82,
  77,54,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,66,83,45,72,73,82,
  79,77,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,
  61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,
  48,45,57,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,
  48,45,53,102,44,99,48,45,100,102,58,48,48,48,48,45,102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,
  112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,
  120,101,48,48,48,10,32,32,115,108,111,116,32,116,121,112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,
  10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,55,100,44,101,48,45,102,102,58,48,48,48,
  48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,66,83,45,76,79,82,79,77,45,82,65,77,10,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,58,56,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,48,48,48,48,48,48,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,
  120,101,48,56,48,48,48,32,98,97,115,101,61,48,120,49,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,
  48,48,48,32,98,97,115,101,61,48,120,50,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,56,48,48,48,32,
  98,97,115,101,61,48,120,49,48,48,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,
  55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,
  32,115,108,111,116,32,116,121,112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,99,48,45,101,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,66,83,45,77,
  67,67,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,
  61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,49,48,45,49,55,58,53,48,48,48,
  45,53,102,102,102,32,109,97,115,107,61,48,120,102,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,
  101,110,116,105,102,105,101,114,61,77,67,67,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,
  48,102,58,53,48,48,48,45,53,102,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,
  102,102,102,102,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,
  98,102,58,54,48,48,48,45,55,102,102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,111,119,110,108,111,97,100,10,32,32,32,32,32,32,
  115,108,111,116,32,116,121,112,101,61,66,83,77,101,109,111,114,121,10,10,98,111,97,114,100,58,32,66,83,45,83,65,
  49,45,82,65,77,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,87,
  54,53,67,56,49,54,83,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,50,50,48,48,45,50,51,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,52,48,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,
  45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,115,108,111,116,32,116,
  121,112,101,61,66,83,77,101,109,111,114,121,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,
  32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,
  48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,52,102,58,48,48,48,48,45,102,
  102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,
  73,110,116,101,114,110,97,108,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,
  44,56,48,45,98,102,58,51,48,48,48,45,51,55,102,102,32,115,105,122,101,61,48,120,56,48,48,10,10,98,111,97,
  114,100,58,32,69,86,69,78,84,45,67,67,57,50,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,
  32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,
  45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,
  32,32,112,114,111,99,101,115,115,111,114,32,109,97,110,117,102,97,99,116,117,114,101,114,61,78,69,67,32,97,114,99,
  104,105,116,101,99,116,117,114,101,61,117,80,68,55,56,50,49,52,10,32,32,32,32,105,100,101,110,116,105,102,105,101,
  114,58,32,67,97,109,112,117,115,32,67,104,97,108,108,101,110,103,101,32,39,57,50,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,99,48,44,101,48,58,48,48,48,48,10,32,32,32,32,109,99,117,10,32,32,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,
  102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,
  61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,
  111,110,116,101,110,116,61,76,101,118,101,108,45,49,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,76,101,118,101,108,45,50,10,32,32,32,32,32,32,109,101,109,111,114,
  121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,76,101,118,101,108,45,51,10,32,32,32,32,100,
  105,112,10,32,32,112,114,111,99,101,115,115,111,114,32,109,97,110,117,102,97,99,116,117,114,101,114,61,78,69,67,32,
  97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,
  110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,
  32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,
  32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,
  117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,
  100,58,32,69,86,69,78,84,45,80,70,57,52,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,51,48,45,
  51,102,44,98,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,
  32,112,114,111,99,101,115,115,111,114,32,109,97,110,117,102,97,99,116,117,114,101,114,61,78,69,67,32,97,114,99,104,
  105,116,101,99,116,117,114,101,61,117,80,68,55,56,50,49,52,10,32,32,32,32,105,100,101,110,116,105,102,105,101,114,
  58,32,80,111,119,101,114,70,101,115,116,32,39,57,52,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  49,48,44,50,48,58,54,48,48,48,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,
  32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,
  97,109,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,
  61,76,101,118,101,108,45,49,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,
  111,110,116,101,110,116,61,76,101,118,101,108,45,50,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,76,101,118,101,108,45,51,10,32,32,32,32,100,105,112,10,32,32,112,
  114,111,99,101,115,115,111,114,32,109,97,110,117,102,97,99,116,117,114,101,114,61,78,69,67,32,97,114,99,104,105,116,
  101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,
  48,45,48,102,44,56,48,45,56,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,102,102,102,10,
  32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,
  114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,
  101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,
  55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,69,88,72,73,
  82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,58,56,48,48,48,
  45,102,102,102,102,32,98,97,115,101,61,48,120,52,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,52,48,45,55,100,58,48,48,48,48,45,102,102,102,102,32,98,97,115,101,61,48,120,52,48,48,48,48,
  48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,56,48,45,98,102,58,56,48,48,48,45,102,102,102,
  102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,10,98,
  111,97,114,100,58,32,69,88,72,73,82,79,77,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,98,97,115,101,61,48,120,52,48,48,48,48,
  48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,58,48,48,48,48,45,102,102,102,
  102,32,98,97,115,101,61,48,120,52,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,99,48,48,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,
  110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,
  44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,58,48,48,48,48,45,55,102,102,102,10,10,98,111,
  97,114,100,58,32,69,88,72,73,82,79,77,45,82,65,77,45,83,72,65,82,80,82,84,67,10,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,58,56,48,48,48,45,102,102,102,102,32,98,97,115,101,
  61,48,120,52,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,58,
  48,48,48,48,45,102,102,102,102,32,98,97,115,101,61,48,120,52,48,48,48,48,48,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,99,
  48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,
  101,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,58,48,48,48,48,45,
  55,102,102,102,10,32,32,114,116,99,32,109,97,110,117,102,97,99,116,117,114,101,114,61,83,104,97,114,112,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,50,56,48,48,45,50,
  56,48,49,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,84,67,32,99,111,110,116,101,110,116,61,
  84,105,109,101,32,109,97,110,117,102,97,99,116,117,114,101,114,61,83,104,97,114,112,10,10,98,111,97,114,100,58,32,
  69,88,76,79,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,
  116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,58,
  56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,56,48,48,48,32,98,97,115,101,61,48,120,52,
  48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,56,48,45,102,102,58,56,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,56,48,48,48,32,98,97,115,101,61,48,120,48,48,48,48,48,
  48,10,10,98,111,97,114,100,58,32,69,88,76,79,82,79,77,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,
  97,100,100,114,101,115,115,61,48,48,45,55,100,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,
  48,56,48,48,48,32,98,97,115,101,61,48,120,52,48,48,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,56,48,48,
  48,32,98,97,115,101,61,48,120,48,48,48,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,
  77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,
  48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,
  10,10,98,111,97,114,100,58,32,69,88,78,69,67,45,76,79,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,
  112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,
  107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,
  101,61,117,80,68,57,54,48,53,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,54,55,
  44,101,48,45,101,55,58,48,48,48,48,45,51,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,
  101,61,117,80,68,57,54,48,53,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,
  111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,57,54,48,53,
  48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,
  116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,57,54,48,53,48,10,32,32,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,54,56,45,54,102,44,101,56,45,101,102,58,48,48,48,48,45,55,102,102,102,
  32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,
  114,100,58,32,69,88,83,80,67,55,49,49,48,45,82,65,77,45,69,80,83,79,78,82,84,67,10,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,69,120,112,97,110,115,105,111,110,10,32,
  32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,52,102,58,48,48,48,48,45,102,102,102,102,10,32,
  32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,83,80,67,55,49,49,48,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,52,56,48,48,45,52,
  56,51,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,53,48,44,53,56,58,48,48,48,48,45,102,
  102,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,
  45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,48,
  48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,
  102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,10,32,32,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,
  102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,114,116,99,32,109,97,110,117,102,97,99,116,117,114,
  101,114,61,69,112,115,111,110,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,
  48,45,98,102,58,52,56,52,48,45,52,56,52,50,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,
  84,67,32,99,111,110,116,101,110,116,61,84,105,109,101,32,109,97,110,117,102,97,99,116,117,114,101,114,61,69,112,115,
  111,110,10,10,98,111,97,114,100,58,32,71,66,45,76,79,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,
  61,48,120,56,48,48,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,
  45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,
  101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,73,67,68,32,114,101,118,105,115,105,111,110,61,50,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,
  45,54,55,102,102,44,55,48,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,79,77,32,99,111,110,116,101,110,116,61,66,111,111,116,32,97,114,99,104,105,116,101,99,116,117,114,101,61,83,77,
  56,51,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,32,32,32,32,115,108,111,116,32,116,121,112,101,61,
  71,97,109,101,66,111,121,10,10,98,111,97,114,100,58,32,71,83,85,45,82,65,77,10,32,32,112,114,111,99,101,115,
  115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,71,83,85,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,52,102,102,10,32,32,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,
  32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,
  48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,52,48,45,53,102,44,99,48,45,100,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,
  102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,55,48,45,55,49,44,102,48,45,102,49,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,
  72,73,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,
  80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,
  45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,98,111,97,114,100,58,32,72,73,82,79,
  77,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,
  80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,
  45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,
  45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,
  101,48,48,48,10,10,98,111,97,114,100,58,32,72,73,84,65,67,72,73,45,76,79,82,79,77,10,32,32,112,114,111,
  99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,83,49,54,57,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,99,48,48,45,54,
  102,102,102,44,55,99,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,
  77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,
  120,56,48,48,48,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,
  116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,55,58,48,
  48,48,48,45,55,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,
  116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,83,49,54,57,
  10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,
  97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,72,71,53,49,66,83,49,54,57,10,32,32,32,32,32,32,109,
  97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,54,98,102,102,
  44,55,48,48,48,45,55,98,102,102,32,109,97,115,107,61,48,120,102,48,48,48,10,32,32,32,32,111,115,99,105,108,
  108,97,116,111,114,10,10,98,111,97,114,100,58,32,76,79,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,
  61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,76,79,82,79,77,45,82,65,77,10,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,55,100,44,56,48,45,102,102,58,56,48,48,48,45,102,102,102,
  102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,
  99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,
  55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,
  98,111,97,114,100,58,32,76,79,82,79,77,45,82,65,77,35,65,10,32,32,109,101,109,111,114,121,32,116,121,112,101,
  61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,
  61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,100,44,102,48,45,102,
  102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,10,98,111,97,114,100,58,32,
  78,69,67,45,72,73,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,
  101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,
  102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,
  115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,112,114,111,99,101,115,
  115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,54,48,48,48,45,55,102,102,102,32,109,
  97,115,107,61,48,120,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,
  110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,
  50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,
  97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,
  101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,
  111,97,114,100,58,32,78,69,67,45,72,73,82,79,77,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,
  109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,55,100,44,99,48,45,102,102,58,48,48,48,48,45,102,102,102,
  102,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,
  10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,54,48,48,
  48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,97,
  114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,
  120,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,
  61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,
  114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,
  101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,
  32,78,69,67,45,76,79,82,79,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,
  116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,
  49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,
  32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,51,48,45,51,102,44,98,48,45,98,102,58,56,48,48,48,
  45,102,102,102,102,32,109,97,115,107,61,48,120,51,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,
  114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,
  111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,
  10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,
  97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,
  108,97,116,111,114,10,10,98,111,97,114,100,58,32,78,69,67,45,76,79,82,79,77,45,82,65,77,10,32,32,109,101,
  109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,
  102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,
  77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,
  48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,
  10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,
  53,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,54,102,44,101,48,45,101,102,58,48,48,
  48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,51,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,
  116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,
  50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,
  97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,
  105,108,108,97,116,111,114,10,10,98,111,97,114,100,58,32,78,69,67,45,76,79,82,79,77,45,82,65,77,35,65,10,
  32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,
  109,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,
  48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,109,101,109,111,114,121,32,116,121,112,
  101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,
  115,115,61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,112,114,111,99,101,
  115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,50,48,45,51,102,44,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,
  109,97,115,107,61,48,120,51,102,102,102,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,
  99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,
  55,55,50,53,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,
  61,68,97,116,97,32,97,114,99,104,105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,68,97,116,97,32,97,114,99,104,
  105,116,101,99,116,117,114,101,61,117,80,68,55,55,50,53,10,32,32,32,32,111,115,99,105,108,108,97,116,111,114,10,
  10,98,111,97,114,100,58,32,79,66,67,49,45,76,79,82,79,77,45,82,65,77,10,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,
  97,115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,
  114,61,79,66,67,49,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,32,32,109,97,112,
  32,97,100,100,114,101,115,115,61,55,48,45,55,49,44,102,48,45,102,49,58,54,48,48,48,45,55,102,102,102,44,101,
  48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,32,32,109,101,109,111,114,121,32,
  116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,10,98,111,97,114,100,58,32,83,65,
  49,10,32,32,112,114,111,99,101,115,115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,87,54,53,67,56,
  49,54,83,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,
  50,50,48,48,45,50,51,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,
  101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,
  120,52,48,56,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,
  48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,
  99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,
  82,65,77,32,99,111,110,116,101,110,116,61,73,110,116,101,114,110,97,108,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,51,48,48,48,45,51,55,102,102,32,115,105,122,
  101,61,48,120,56,48,48,10,10,98,111,97,114,100,58,32,83,65,49,45,82,65,77,10,32,32,112,114,111,99,101,115,
  115,111,114,32,97,114,99,104,105,116,101,99,116,117,114,101,61,87,54,53,67,56,49,54,83,10,32,32,32,32,109,97,
  112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,50,50,48,48,45,50,51,102,102,10,
  32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,
  56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,52,48,56,48,48,48,10,32,32,
  32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,
  32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,
  111,103,114,97,109,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,
  116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,
  48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,115,105,122,101,61,48,120,50,48,48,48,10,32,32,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,52,48,45,52,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,
  32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,73,110,116,101,114,110,97,
  108,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,
  51,48,48,48,45,51,55,102,102,32,115,105,122,101,61,48,120,56,48,48,10,10,98,111,97,114,100,58,32,83,68,68,
  49,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,83,68,68,49,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,52,56,48,48,45,52,
  56,48,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,
  45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,32,32,109,101,109,111,
  114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,10,98,111,97,
  114,100,58,32,83,68,68,49,45,82,65,77,10,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,
  111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,
  102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,55,48,45,55,51,58,48,48,48,48,45,102,102,102,102,32,109,97,
  115,107,61,48,120,56,48,48,48,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,
  61,83,68,68,49,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,
  102,58,52,56,48,48,45,52,56,48,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,
  100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,10,32,32,32,32,
  32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,32,32,
  32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,
  114,97,109,10,10,98,111,97,114,100,58,32,83,80,67,55,49,49,48,45,82,65,77,10,32,32,112,114,111,99,101,115,
  115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,83,80,67,55,49,49,48,10,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,52,56,48,48,45,52,56,51,102,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,53,48,44,53,56,58,48,48,48,48,45,102,102,102,102,10,32,32,32,
  32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,
  98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,48,48,48,48,10,32,32,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,
  107,61,48,120,99,48,48,48,48,48,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,
  32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,32,32,32,109,101,109,111,114,121,32,116,121,
  112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,97,10,32,32,32,32,109,101,109,111,114,121,32,116,
  121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,118,101,10,32,32,32,32,32,32,109,97,112,32,97,
  100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,54,48,48,48,45,55,102,102,102,32,109,97,115,
  107,61,48,120,101,48,48,48,10,10,98,111,97,114,100,58,32,83,80,67,55,49,49,48,45,82,65,77,45,69,80,83,
  79,78,82,84,67,10,32,32,112,114,111,99,101,115,115,111,114,32,105,100,101,110,116,105,102,105,101,114,61,83,80,67,
  55,49,49,48,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,52,56,48,48,45,52,56,51,102,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,53,48,44,53,56,
  58,48,48,48,48,45,102,102,102,102,10,32,32,32,32,109,99,117,10,32,32,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,56,48,48,48,48,48,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,99,48,45,102,102,
  58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,99,48,48,48,48,48,10,32,32,32,32,32,32,109,
  101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,
  32,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,68,97,116,
  97,10,32,32,32,32,109,101,109,111,114,121,32,116,121,112,101,61,82,65,77,32,99,111,110,116,101,110,116,61,83,97,
  118,101,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,51,102,44,56,48,45,98,102,
  58,54,48,48,48,45,55,102,102,102,32,109,97,115,107,61,48,120,101,48,48,48,10,32,32,114,116,99,32,109,97,110,
  117,102,97,99,116,117,114,101,114,61,69,112,115,111,110,10,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,
  48,48,45,51,102,44,56,48,45,98,102,58,52,56,52,48,45,52,56,52,50,10,32,32,32,32,109,101,109,111,114,121,
  32,116,121,112,101,61,82,84,67,32,99,111,110,116,101,110,116,61,84,105,109,101,32,109,97,110,117,102,97,99,116,117,
  114,101,114,61,69,112,115,111,110,10,10,98,111,97,114,100,58,32,83,84,45,76,79,82,79,77,10,32,32,109,101,109,
  111,114,121,32,116,121,112,101,61,82,79,77,32,99,111,110,116,101,110,116,61,80,114,111,103,114,97,109,10,32,32,32,
  32,109,97,112,32,97,100,100,114,101,115,115,61,48,48,45,49,102,44,56,48,45,57,102,58,56,48,48,48,45,102,102,
  102,102,32,109,97,115,107,61,48,120,56,48,48,48,10,32,32,115,108,111,116,32,116,121,112,101,61,83,117,102,97,109,
  105,84,117,114,98,111,10,32,32,32,32,114,111,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,50,48,45,51,102,44,97,48,45,98,102,58,56,48,48,48,45,102,102,102,102,32,109,97,115,107,61,48,120,56,48,
  48,48,10,32,32,32,32,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,61,54,48,45,
  54,102,44,101,48,45,101,102,58,48,48,48,48,45,102,102,102,102,10,32,32,115,108,111,116,32,116,121,112,101,61,83,
  117,102,97,109,105,84,117,114,98,111,10,32,32,32,32,114,111,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,
  114,101,115,115,61,52,48,45,53,102,44,99,48,45,100,102,58,48,48,48,48,45,102,102,102,102,32,109,97,115,107,61,
  48,120,56,48,48,48,10,32,32,32,32,114,97,109,10,32,32,32,32,32,32,109,97,112,32,97,100,100,114,101,115,115,
  61,55,48,45,55,100,44,102,48,45,102,102,58,48,48,48,48,45,102,102,102,102,10,10,
};
const unsigned char IPLROM[64] = {
  205,239,189,232,0,198,29,208,252,143,170,244,143,187,245,120,204,244,208,251,47,25,235,244,208,252,126,244,208,11,228,245,
  203,244,215,0,252,208,243,171,1,16,239,126,244,16,235,186,246,218,0,186,244,196,244,221,93,208,219,31,0,0,192,255,
};
}
namespace WonderSwan {
const unsigned char Boot[4096] = {
  250,184,0,0,139,208,139,232,142,208,188,0,32,142,216,142,192,230,181,176,4,230,160,228,181,138,216,208,235,115,5,234,
  0,0,0,64,185,0,0,228,160,36,128,117,12,65,129,249,128,0,117,3,233,6,2,235,238,228,181,36,2,116,5,234,
  16,0,0,64,176,8,230,160,184,48,1,231,188,176,64,230,190,191,0,0,185,0,32,184,0,0,252,243,171,184,240,63,
  142,192,187,252,0,38,138,7,190,2,7,136,4,36,12,230,160,176,158,230,22,176,155,230,23,51,192,230,16,230,17,230,
  136,230,137,230,138,230,139,230,5,230,6,230,144,230,145,176,12,230,4,184,32,100,231,28,184,168,252,231,30,176,1,230,
  7,230,20,184,48,117,231,48,190,0,6,187,48,0,185,16,0,154,71,8,0,255,61,0,0,116,3,233,127,1,137,20,
  131,198,2,67,226,235,190,0,6,185,16,0,128,60,43,114,3,198,4,0,70,226,245,178,153,154,50,10,0,255,178,153,
  154,50,10,0,255,178,18,154,50,10,0,255,178,49,154,50,10,0,255,128,60,2,118,3,198,4,0,70,128,60,4,118,
  3,198,4,0,184,176,255,142,192,187,189,2,190,0,32,185,232,1,38,138,7,136,4,136,68,1,131,198,2,67,226,242,
  185,61,0,187,189,2,154,14,9,0,255,187,152,0,199,7,72,10,199,71,2,0,255,176,32,230,176,176,64,230,182,230,
  178,176,64,230,181,185,15,0,226,254,228,181,168,2,116,12,190,22,7,198,4,1,154,63,2,0,255,250,187,2,7,138,
  7,36,1,187,20,7,136,7,60,1,117,6,176,2,230,21,235,4,176,4,230,21,154,166,8,0,255,154,165,7,0,255,
  190,22,7,198,4,2,251,244,190,24,7,128,60,0,116,247,250,51,192,230,178,176,255,230,182,190,0,6,131,124,30,255,
  116,3,255,68,30,184,240,63,142,192,187,246,0,38,139,7,38,138,87,2,59,68,22,117,5,58,84,24,116,15,137,68,
  22,136,84,24,128,124,28,255,116,3,254,68,28,187,48,0,185,16,0,139,20,154,116,8,0,255,61,0,0,116,3,233,
  91,0,131,198,2,67,226,235,190,249,0,38,138,4,36,128,117,4,176,128,230,190,51,192,231,0,230,7,230,4,230,5,
  230,6,230,176,230,144,230,145,230,143,184,0,0,142,192,191,0,0,185,0,32,184,0,0,252,243,171,185,13,0,184,0,
  255,142,216,190,48,2,191,0,4,243,164,234,0,4,0,0,228,160,36,140,12,1,230,160,234,0,0,255,255,244,244,250,
  252,51,192,142,192,187,22,7,198,7,1,185,0,4,191,0,8,243,171,185,11,0,191,64,6,190,0,6,243,165,184,48,
  117,231,34,184,0,80,231,32,176,7,230,6,184,176,255,142,192,187,42,6,198,7,0,232,108,1,232,203,0,176,5,231,
  0,176,4,187,43,6,230,21,198,7,122,176,1,230,20,251,244,187,35,6,138,7,10,192,116,246,232,6,2,187,32,6,
  154,226,2,0,255,232,203,4,232,94,1,187,43,6,254,15,117,4,176,0,230,21,187,42,6,246,7,1,117,8,187,35,
  6,198,7,0,235,202,232,114,4,6,51,192,230,5,187,24,24,137,7,142,192,185,0,4,191,0,8,243,171,7,230,21,
  250,203,176,32,230,181,185,15,0,226,254,228,181,36,15,138,224,176,64,230,181,185,15,0,226,254,228,181,36,15,177,4,
  210,224,10,196,138,224,138,7,50,196,34,196,136,71,1,138,7,136,71,2,136,39,203,10,192,116,16,60,10,119,3,4,
  27,195,60,36,119,3,44,10,195,4,2,195,10,192,116,23,60,27,116,5,119,6,4,10,195,50,192,195,60,38,116,249,
  119,3,44,27,195,44,2,195,186,0,0,185,11,0,187,42,0,3,218,38,139,63,187,64,0,3,218,38,139,55,232,118,
  0,66,66,226,233,190,0,6,191,48,6,187,150,8,185,16,0,138,4,136,7,232,159,255,136,5,71,70,67,67,226,241,
  190,16,6,138,4,187,150,9,232,205,0,70,138,4,187,154,9,232,196,0,190,18,6,138,4,187,214,9,232,185,0,190,
  19,6,138,4,187,22,10,232,174,0,187,20,6,138,7,177,3,210,224,180,0,190,167,0,3,240,191,150,10,232,23,0,
  187,21,6,138,7,177,2,210,224,180,0,190,191,0,3,240,191,22,11,232,1,0,195,38,138,4,70,10,192,116,6,136,
  5,71,71,235,242,195,187,0,24,51,192,185,28,0,137,7,131,195,2,226,249,187,24,24,186,44,0,137,23,187,39,6,
  198,7,1,176,1,232,45,1,195,187,33,6,138,7,168,255,116,69,168,5,116,4,232,28,1,195,138,208,187,39,6,138,
  7,180,0,72,120,26,116,28,122,7,72,116,27,123,29,235,35,64,123,28,246,194,64,116,30,187,42,6,198,7,1,195,
  232,119,0,195,232,102,1,195,232,255,1,195,232,52,2,195,232,129,2,195,232,178,2,195,138,224,177,4,210,232,64,136,
  7,138,196,36,15,64,136,71,2,195,96,190,86,0,182,0,3,242,3,242,38,139,28,67,208,224,185,28,0,128,39,241,
  8,7,67,67,226,247,97,195,232,223,255,82,10,210,117,7,178,7,232,213,255,235,10,128,250,3,119,5,178,8,232,201,
  255,90,195,187,36,6,254,7,128,39,31,117,12,228,5,10,192,176,6,116,2,50,192,230,5,195,138,194,187,40,6,138,
  23,182,0,168,10,116,57,168,2,116,28,128,250,15,117,11,198,7,0,187,2,24,199,7,24,88,195,254,7,187,2,24,
  187,3,24,128,7,8,195,128,250,0,117,11,198,7,15,187,2,24,199,7,24,208,195,254,15,187,3,24,128,47,8,195,
  168,64,116,17,187,48,6,3,218,138,7,254,192,60,45,114,21,176,0,235,17,168,128,116,27,187,48,6,3,218,138,7,
  44,1,115,2,176,44,136,7,191,150,8,3,250,3,250,232,250,253,136,5,195,187,39,6,138,23,168,1,116,7,10,210,
  116,90,74,235,6,128,250,6,115,82,66,182,0,82,138,23,176,0,232,51,255,90,176,1,232,45,255,136,23,190,40,6,
  198,4,0,190,41,6,198,4,0,190,28,0,3,242,3,242,38,139,4,187,26,24,137,7,128,196,8,187,2,24,128,250,
  1,185,6,0,119,12,73,115,2,4,8,137,7,131,195,4,51,192,137,7,131,195,4,128,196,8,226,246,187,39,6,184,
  0,80,128,63,6,117,3,184,48,117,231,32,195,138,194,187,41,6,138,23,182,0,168,10,116,54,168,2,116,25,128,250,
  3,117,11,198,7,0,187,2,24,199,7,48,88,195,254,7,187,3,24,128,7,8,195,128,250,0,117,11,198,7,3,187,
  2,24,199,7,48,112,195,254,15,187,3,24,128,47,8,195,168,192,116,85,187,150,9,190,16,6,128,250,2,114,4,70,
  187,154,9,168,64,138,4,116,30,246,194,1,117,10,4,16,60,160,114,48,36,15,235,44,64,138,224,36,15,60,10,138,
  196,114,33,36,240,235,29,246,194,1,117,14,168,240,116,4,44,16,235,16,36,15,12,144,235,10,168,15,117,5,36,240,
  12,9,64,72,136,4,232,15,254,195,246,194,202,116,51,187,18,6,138,7,246,194,66,116,15,64,60,10,117,2,176,16,
  60,19,114,22,176,1,235,18,10,192,117,1,64,72,60,15,117,2,176,9,10,192,117,2,176,18,136,7,187,214,9,232,
  214,253,195,246,194,202,116,75,187,19,6,138,7,246,194,66,116,27,64,60,10,117,2,176,16,60,26,117,2,176,32,60,
  42,117,2,176,48,60,50,114,34,176,1,235,30,10,192,117,1,64,72,60,15,117,2,176,9,60,31,117,2,176,25,60,
  47,117,2,176,41,10,192,117,2,176,49,136,7,187,22,10,232,133,253,195,246,194,202,116,47,187,20,6,138,7,180,0,
  246,194,136,116,8,72,121,13,184,2,0,235,8,254,192,60,3,114,2,176,0,136,7,177,3,210,224,180,0,190,167,0,
  3,240,191,150,10,232,207,252,195,246,194,202,116,44,187,21,6,138,7,180,0,246,194,136,116,8,72,121,12,184,4,0,
  235,7,64,60,5,114,2,176,0,136,7,208,224,208,224,190,191,0,3,240,191,22,11,232,157,252,195,190,48,6,191,0,
  6,185,16,0,138,4,232,227,251,136,5,71,70,226,245,190,0,6,191,64,6,185,11,0,139,4,139,21,131,198,2,131,
  199,2,59,194,117,3,226,240,195,187,29,6,254,7,117,2,254,15,195,187,37,6,191,32,6,138,5,190,34,6,58,4,
  117,31,36,202,116,27,128,63,37,114,19,187,38,6,254,7,128,63,15,114,15,198,7,0,187,33,6,8,7,195,254,7,
  195,198,7,0,195,30,96,51,192,230,136,230,137,230,138,230,139,230,144,187,80,7,137,71,2,137,71,4,199,7,1,0,
  142,192,191,0,4,184,176,255,142,216,190,213,0,185,16,0,252,243,165,176,11,230,145,176,16,230,143,176,3,230,144,97,
  31,203,6,96,187,80,7,131,63,1,117,88,184,176,255,142,192,131,127,4,0,117,74,139,119,2,38,139,132,254,0,231,
  128,38,138,132,0,1,230,136,131,238,9,38,139,132,254,0,231,130,38,138,132,0,1,230,137,131,71,2,3,131,127,2,
  117,114,12,199,7,0,0,51,192,230,136,230,137,235,18,131,127,2,81,114,7,199,71,4,3,0,235,5,199,71,4,1,
  0,255,79,4,97,7,203,83,184,1,0,131,251,64,115,34,139,195,5,128,1,231,188,176,16,230,190,51,210,66,184,2,
  0,131,250,32,116,12,228,190,36,1,116,241,229,186,139,208,51,192,91,203,82,83,184,1,0,131,251,64,115,37,139,195,
  5,64,1,231,188,139,194,231,186,176,32,230,190,51,210,66,184,2,0,129,250,0,22,116,10,228,190,36,2,60,2,117,
  238,51,192,91,90,203,184,0,112,231,32,184,0,80,231,34,184,0,64,231,36,184,0,48,231,38,184,0,32,231,40,184,
  0,16,231,42,51,192,231,44,142,192,191,0,8,185,0,4,243,171,184,176,255,142,192,187,20,7,139,7,60,1,117,8,
  187,187,1,191,154,9,235,6,187,115,1,191,22,9,185,6,0,81,185,6,0,38,139,7,137,5,131,199,2,131,195,2,
  226,243,131,199,52,89,226,233,184,5,0,231,0,203,81,51,255,186,1,128,185,8,0,81,38,138,1,185,8,0,87,83,
  51,255,139,222,132,198,116,5,8,17,8,81,1,208,238,131,199,2,226,240,91,95,182,128,208,226,71,89,226,217,131,198,
  16,131,195,8,89,226,199,203,87,187,0,6,185,16,0,139,241,78,128,56,0,117,2,226,248,186,16,0,43,209,190,20,
  7,128,60,1,117,10,208,226,208,226,129,194,8,80,235,14,138,194,138,240,50,210,208,230,208,230,129,194,96,48,131,249,
  0,116,5,154,138,9,0,255,95,203,82,83,138,193,230,6,191,0,24,190,20,7,50,228,138,7,128,60,1,117,2,4,
  61,137,5,137,85,2,67,131,199,4,128,60,1,117,5,128,194,8,235,3,128,198,8,226,221,91,90,203,87,190,20,7,
  191,77,10,128,60,1,117,3,191,91,8,185,6,0,247,225,187,3,2,3,216,184,176,255,142,192,185,6,0,38,138,7,
  138,224,36,15,128,228,240,81,185,4,0,210,236,89,139,208,3,208,128,60,1,117,28,81,185,6,0,128,37,240,0,21,
  128,101,64,240,0,117,64,131,199,66,226,239,89,129,239,12,1,235,26,81,185,6,0,128,37,240,0,21,128,101,2,240,
  0,117,2,131,239,62,226,239,89,129,199,120,1,67,226,173,95,203,138,4,58,194,118,5,198,4,0,235,9,36,15,60,
  9,118,3,198,4,0,70,203,96,190,22,7,128,60,1,117,8,187,35,6,198,7,1,235,76,128,60,2,117,21,190,16,
  7,254,4,128,60,32,117,9,198,4,0,190,22,7,198,4,0,235,50,154,226,7,0,255,190,16,7,254,4,128,60,2,
  117,35,51,192,136,4,191,18,7,128,61,44,117,4,176,0,230,21,128,61,31,115,12,138,5,154,188,9,0,255,154,72,
  9,0,255,254,5,191,18,7,128,61,106,114,10,51,192,231,0,190,24,7,198,4,1,176,64,230,182,97,207,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  43,43,43,43,43,43,6,5,13,1,12,5,13,1,12,5,0,0,43,43,1,2,1,0,2,0,15,0,16,80,48,80,
  56,80,64,80,80,80,96,80,120,96,140,8,68,9,140,9,202,9,14,10,142,10,2,11,218,11,214,8,150,10,22,11,
  104,0,109,0,118,0,123,0,129,0,133,0,137,0,147,0,150,0,167,0,191,0,128,8,128,9,192,9,0,10,128,10,
  0,11,192,11,192,8,64,9,24,11,23,15,0,12,19,28,30,18,14,11,35,0,35,15,11,28,0,23,25,24,30,18,
  0,14,11,35,0,29,15,34,0,12,22,25,25,14,30,35,26,15,0,25,21,0,43,43,43,43,43,43,43,43,43,43,
  43,43,43,43,43,43,0,41,159,159,159,159,159,0,0,23,11,22,15,159,159,0,0,16,15,23,11,22,15,0,0,41,
  159,0,0,11,159,0,0,12,159,0,0,25,159,0,0,11,12,0,0,0,0,255,238,221,204,187,170,153,136,119,102,85,
  68,51,34,17,0,255,238,221,204,187,170,153,136,119,102,85,68,51,34,17,0,147,7,240,153,7,240,159,7,240,164,7,
  240,169,7,240,174,7,240,179,7,240,183,7,240,187,7,240,191,7,225,195,7,225,198,7,225,201,7,210,205,7,195,207,
  7,180,210,7,165,213,7,150,215,7,135,217,7,120,220,7,105,222,7,90,224,7,75,225,7,60,227,7,45,229,7,30,
  230,7,15,230,7,15,230,7,14,230,7,13,230,7,12,230,7,11,230,7,10,230,7,9,230,7,8,230,7,7,230,7,
  6,230,7,5,230,7,4,230,7,3,230,7,2,230,7,1,230,7,0,46,12,45,12,45,12,45,12,45,12,46,76,47,
  12,48,12,49,12,50,12,51,12,47,76,52,12,53,12,54,12,55,12,56,12,52,76,47,12,57,12,58,12,50,12,47,
  76,45,12,52,12,59,12,60,12,55,12,52,76,45,12,46,140,45,12,45,12,45,12,45,12,46,204,107,76,113,12,108,
  12,113,12,108,12,107,12,106,12,120,12,118,12,114,12,109,12,106,12,106,12,121,12,119,12,115,12,110,12,106,12,106,
  12,116,12,111,12,116,12,111,12,106,12,106,12,113,140,108,140,117,12,112,12,106,12,107,204,106,12,106,12,113,140,108,
  140,107,140,101,102,102,102,102,102,84,102,102,102,102,102,67,101,102,102,102,102,50,84,102,102,102,102,33,67,101,102,102,
  102,16,50,84,102,102,102,1,33,67,101,102,102,18,16,50,84,102,102,35,1,33,67,101,102,52,18,16,50,84,102,69,
  35,1,33,67,101,86,52,18,16,50,100,102,69,35,1,33,99,102,86,52,18,16,98,102,102,69,35,1,97,101,102,86,
  52,18,96,84,102,102,69,35,97,67,101,102,86,52,98,50,84,102,102,69,99,33,67,101,102,86,100,16,50,84,102,102,
  101,0,33,67,101,102,102,0,16,50,84,102,102,0,0,33,67,101,102,0,0,16,50,84,102,0,0,0,33,67,101,0,
  0,0,16,50,100,0,0,0,0,33,99,0,0,0,0,16,98,0,0,0,0,0,97,0,0,0,0,0,96,0,0,0,
  0,0,0,0,0,62,99,103,107,115,99,62,0,60,12,12,12,12,12,12,0,126,3,3,62,96,96,127,0,126,3,3,
  62,3,3,126,0,30,54,102,102,102,127,6,0,127,96,96,126,3,3,126,0,62,96,96,126,99,99,62,0,127,99,6,
  12,24,24,24,0,62,99,99,62,99,99,62,0,62,99,99,63,3,3,62,0,28,54,99,99,127,99,99,0,126,99,99,
  126,99,99,126,0,62,99,96,96,96,99,62,0,124,102,99,99,99,102,124,0,127,96,96,126,96,96,127,0,127,96,96,
  126,96,96,96,0,63,96,96,103,99,99,62,0,99,99,99,127,99,99,99,0,60,24,24,24,24,24,60,0,15,3,3,
  99,99,99,62,0,99,102,108,120,108,102,99,0,96,96,96,96,96,96,127,0,99,119,127,107,99,99,99,0,99,115,123,
  111,103,99,99,0,62,99,99,99,99,99,62,0,126,99,99,126,96,96,96,0,62,99,99,107,111,103,62,0,126,99,99,
  126,108,102,99,0,62,99,96,62,3,99,62,0,126,24,24,24,24,24,24,0,99,99,99,99,99,99,62,0,99,99,99,
  54,54,28,8,0,99,107,107,107,127,54,34,0,99,99,54,28,54,99,99,0,102,102,102,60,24,24,24,0,127,3,6,
  12,24,48,127,0,34,119,127,127,62,28,8,0,24,28,22,18,18,112,96,0,8,8,8,127,8,8,8,0,0,0,0,
  127,0,0,0,0,60,102,102,12,24,0,24,0,0,0,0,0,0,96,96,0,127,0,0,0,0,0,0,0,16,24,28,
  30,28,24,16,0,255,255,255,255,255,255,255,255,15,63,127,127,255,255,255,255,255,248,248,248,248,248,248,248,255,1,0,
  0,248,252,248,192,255,252,252,252,120,120,248,240,255,31,31,31,15,143,143,135,255,15,15,7,7,3,3,1,248,248,248,
  248,248,248,248,248,193,192,248,252,248,0,0,1,241,241,97,99,99,64,192,192,199,199,195,227,227,33,49,49,17,16,24,
  24,28,28,30,30,255,15,3,1,240,248,252,252,255,252,252,252,248,248,120,112,252,252,252,252,248,0,1,7,113,113,97,
  99,227,192,192,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
};
}
namespace WonderSwanColor {
const unsigned char Boot[8192] = {
  250,253,248,184,0,0,139,216,139,200,139,208,142,208,142,216,142,192,188,0,32,139,232,139,240,139,248,176,4,230,160,176,
  0,230,181,228,181,168,1,116,5,234,0,0,0,64,185,128,0,228,160,168,128,117,5,226,248,233,249,3,228,181,168,2,
  116,5,234,16,0,0,64,184,170,85,231,194,229,194,61,170,85,116,3,233,223,3,184,255,255,231,194,104,255,63,31,160,
  0,0,60,234,116,3,233,204,3,176,8,230,160,176,138,230,96,184,0,19,231,188,176,64,230,190,51,192,191,254,255,185,
  0,128,243,171,252,231,16,231,18,230,5,230,6,230,136,230,137,230,138,230,139,231,128,231,130,231,132,231,134,230,148,230,
  140,230,144,230,145,176,33,230,7,176,12,230,4,160,12,0,54,162,150,6,36,12,230,160,160,5,0,36,15,116,3,233,
  115,3,160,13,0,36,240,116,3,233,105,3,190,0,6,187,48,0,185,20,0,232,215,3,61,0,0,116,3,233,85,3,
  54,137,20,70,70,67,226,237,246,6,5,0,128,117,50,54,246,6,35,6,128,116,42,190,6,96,181,0,54,138,14,38,
  6,191,67,16,208,225,3,249,46,139,13,75,232,160,3,61,0,0,116,3,233,30,3,54,137,20,70,70,67,226,237,235,
  15,104,128,255,31,190,6,0,191,6,96,185,133,3,243,165,187,0,6,185,16,0,54,128,63,43,114,4,54,198,7,0,
  67,226,243,178,153,232,242,2,178,153,232,237,2,178,18,232,232,2,178,49,232,227,2,54,128,63,3,114,4,54,198,7,
  0,67,54,128,63,5,114,4,54,198,7,0,187,35,6,54,246,7,60,116,4,54,128,39,192,54,138,7,138,208,36,3,
  230,158,138,194,128,226,64,192,234,5,128,202,1,138,194,230,20,54,198,6,120,6,127,187,36,6,54,131,63,15,114,4,
  54,198,7,0,54,160,150,6,36,1,54,162,0,112,14,31,190,71,16,191,0,48,185,112,1,164,71,226,252,104,0,6,
  31,139,54,14,0,180,0,160,11,0,54,163,146,6,179,8,246,227,139,200,54,137,14,148,6,246,6,10,0,128,117,6,
  164,71,226,252,235,2,243,165,54,199,6,152,0,218,15,54,140,14,154,0,176,32,230,176,176,64,230,182,230,178,230,181,
  185,10,0,226,254,228,181,168,2,116,15,54,198,6,152,6,1,232,232,2,54,198,6,152,6,0,54,160,0,112,138,200,
  176,4,210,232,230,21,232,136,12,22,31,190,0,48,191,0,32,54,128,62,0,112,1,116,13,54,139,14,148,6,129,193,
  112,1,243,165,235,61,54,139,14,146,6,131,193,46,186,1,128,81,185,2,0,81,51,237,185,8,0,81,51,219,185,8,
  0,132,48,116,3,38,8,19,208,194,67,67,226,243,208,206,69,69,89,226,230,70,71,89,226,219,131,198,14,131,199,14,
  89,226,206,104,0,6,31,139,54,12,0,51,192,191,0,254,181,0,138,14,10,0,138,209,128,225,31,246,194,128,117,9,
  165,165,131,199,28,226,249,235,9,165,165,165,165,131,199,24,226,247,54,139,22,36,6,191,147,14,3,250,3,250,46,255,
  53,54,143,6,130,255,191,0,8,185,0,4,243,171,139,30,16,0,54,128,62,0,112,1,116,50,182,0,138,22,22,0,
  209,226,176,64,43,194,54,163,144,6,139,62,18,0,138,14,23,0,81,138,14,22,0,139,7,54,137,5,71,71,67,67,
  226,245,54,3,62,144,6,89,226,232,235,76,138,22,22,0,176,64,246,226,64,64,54,163,144,6,139,62,20,0,181,0,
  138,14,23,0,81,181,0,138,14,22,0,139,7,138,244,128,230,192,116,18,128,254,192,116,13,128,254,128,117,5,128,236,
  64,235,3,128,196,64,54,137,5,131,199,64,67,67,226,219,54,43,62,144,6,89,226,204,251,244,54,128,62,153,6,0,
  116,247,250,176,0,230,178,176,255,230,182,54,255,6,30,6,117,5,54,255,14,30,6,54,139,30,22,6,54,137,30,32,
  6,54,138,14,24,6,54,136,14,34,6,104,255,63,31,161,6,0,138,22,8,0,59,195,117,4,58,209,116,21,54,163,
  22,6,54,136,22,24,6,54,254,6,28,6,117,5,54,254,14,28,6,190,0,6,187,48,0,185,19,0,54,139,20,232,
  18,1,61,0,0,117,110,70,70,67,226,240,160,9,0,36,128,117,4,176,128,230,190,51,192,230,0,230,1,230,7,230,
  4,231,16,231,18,230,5,230,6,230,176,230,136,230,137,230,138,230,139,231,128,231,130,231,132,231,134,230,148,230,140,230,
  144,230,145,230,143,139,248,185,0,127,243,171,184,255,255,185,0,1,243,171,176,10,230,96,185,11,0,14,31,190,42,4,
  191,0,4,243,164,234,0,4,0,0,228,160,254,192,230,160,234,0,0,255,255,176,1,230,98,244,54,138,7,58,194,118,
  6,54,198,7,0,235,10,36,15,60,9,118,4,54,198,7,0,67,195,96,30,104,0,6,31,185,16,0,139,217,190,0,
  6,254,203,54,128,56,0,117,2,226,246,138,195,178,4,246,226,138,224,139,30,28,0,139,22,30,0,42,252,42,208,176,
  16,2,6,9,0,230,6,22,31,191,0,24,185,16,0,164,38,198,5,8,71,54,128,62,0,112,1,116,7,139,195,128,
  199,8,235,5,139,194,128,194,8,171,226,227,31,97,195,184,0,24,3,195,231,188,176,16,230,190,186,0,0,66,184,2,
  0,131,250,32,116,13,228,190,36,1,116,241,229,186,139,208,184,0,0,195,184,0,20,3,195,231,188,139,194,231,186,176,
  32,230,190,186,0,0,66,184,2,0,129,250,0,22,116,11,228,190,36,2,60,2,117,238,184,0,0,195,30,51,192,187,
  255,15,142,216,185,11,0,191,48,6,190,0,6,243,165,54,199,6,0,254,221,13,54,199,6,2,254,136,8,54,199,6,
  4,254,0,15,54,163,6,254,54,137,30,128,254,54,199,6,130,254,136,8,54,163,160,254,54,137,30,162,254,54,137,30,
  192,254,54,163,194,254,54,255,54,36,6,54,143,6,130,255,54,199,6,162,255,153,15,54,163,194,255,232,83,9,180,32,
  191,0,8,185,0,4,243,171,180,8,191,0,16,185,0,4,243,171,185,128,0,171,71,71,226,251,14,31,190,1,21,191,
  0,64,185,80,1,243,165,190,0,6,191,80,6,185,16,0,54,138,4,232,95,2,54,136,5,71,70,226,243,232,38,1,
  232,33,2,232,73,8,54,198,6,136,6,1,54,198,6,134,6,7,176,7,230,6,54,199,6,24,24,44,11,54,198,6,
  116,6,1,176,1,232,48,4,176,7,230,0,176,4,230,21,54,198,6,120,6,126,54,198,6,160,6,1,251,244,228,2,
  60,146,117,250,54,128,62,135,6,1,117,26,232,215,0,232,210,1,232,250,7,54,198,6,116,6,1,176,1,232,248,3,
  54,198,6,135,6,0,232,80,9,54,128,62,112,6,0,116,204,232,21,3,232,103,0,232,254,6,232,29,2,54,160,116,
  6,54,162,132,6,232,39,7,232,12,8,54,254,14,120,6,117,4,176,0,230,21,54,246,6,119,6,1,117,8,54,198,
  6,112,6,0,235,151,232,147,6,184,0,25,230,5,230,6,54,163,24,24,176,4,230,1,51,192,185,160,3,191,0,8,
  243,171,54,199,6,0,254,0,0,230,1,230,0,54,198,6,120,6,127,31,250,54,160,35,6,36,3,230,158,195,176,16,
  230,181,185,10,0,226,254,228,181,36,15,138,224,176,32,230,181,185,10,0,226,254,228,181,36,15,138,208,176,64,230,181,
  185,10,0,226,254,228,181,36,15,192,224,4,10,194,139,208,54,161,96,6,54,163,100,6,51,194,35,194,54,163,98,6,
  54,137,22,96,6,195,96,51,210,54,128,62,133,6,1,117,3,233,141,0,190,51,18,181,0,177,2,232,208,0,177,13,
  187,207,17,3,218,46,139,63,187,247,17,3,218,46,139,55,232,51,1,66,66,226,233,187,22,17,190,80,6,177,16,54,
  138,4,232,5,1,180,9,54,137,7,70,67,67,226,240,54,160,16,6,187,214,17,232,157,1,54,160,17,6,187,218,17,
  232,147,1,54,160,18,6,187,22,18,232,137,1,54,160,19,6,187,86,18,232,127,1,54,160,20,6,192,224,3,180,0,
  190,203,18,3,240,191,214,18,232,219,0,54,160,21,6,192,224,2,180,0,190,227,18,3,240,191,86,19,232,199,0,97,
  195,190,31,18,177,9,232,69,0,177,7,187,233,17,3,218,46,139,63,187,17,18,3,218,46,139,55,232,168,0,66,66,
  226,233,54,160,35,6,138,216,36,3,208,224,180,0,190,247,18,3,240,191,214,17,232,141,0,128,227,64,192,235,3,183,
  0,190,255,18,3,243,191,150,18,232,122,0,97,195,81,131,198,2,46,139,28,177,28,54,199,7,0,8,67,67,226,247,
  89,226,235,195,54,138,30,133,6,208,227,183,0,46,139,151,233,7,138,194,187,106,16,185,6,0,232,16,0,138,198,187,
  68,16,185,13,0,232,5,0,195,13,11,11,13,67,54,136,7,67,226,249,195,10,192,116,16,60,10,119,3,4,27,195,
  60,36,119,3,44,10,195,4,2,195,10,192,116,23,60,27,116,5,119,6,4,10,195,50,192,195,60,38,116,249,119,3,
  44,27,195,44,2,195,46,138,4,70,60,255,116,11,54,136,5,71,54,128,13,9,71,235,237,195,54,160,98,6,168,255,
  117,1,195,168,5,116,4,232,174,1,195,138,208,54,160,116,6,54,128,62,133,6,1,116,58,60,0,116,26,60,1,116,
  26,60,2,116,26,60,3,116,26,60,4,116,26,60,5,116,26,60,6,116,26,235,50,232,201,0,195,232,249,0,195,232,
  46,2,195,232,206,2,195,232,7,3,195,232,88,3,195,232,140,3,195,60,0,116,224,60,1,116,6,60,2,116,6,235,
  8,232,175,3,195,232,232,3,195,246,194,64,117,1,195,54,198,6,119,6,1,195,138,224,192,232,4,254,192,54,136,7,
  54,128,79,1,1,138,196,36,15,254,192,54,136,71,2,54,128,79,3,1,195,232,38,0,82,54,128,62,133,6,1,116,
  27,128,250,0,116,22,128,250,1,117,7,178,8,232,14,0,235,10,128,250,4,119,5,178,9,232,2,0,90,195,96,190,
  31,18,54,128,62,133,6,1,117,3,190,51,18,182,0,3,242,3,242,46,139,28,67,208,224,185,28,0,54,128,39,241,
  54,8,7,67,67,226,245,97,195,54,254,6,113,6,54,128,38,113,6,31,117,12,228,5,10,192,176,6,116,2,176,0,
  230,5,195,187,98,6,54,246,7,8,116,18,54,198,6,133,6,0,54,198,6,134,6,7,54,198,6,135,6,1,54,246,
  7,2,116,18,54,198,6,133,6,1,54,198,6,134,6,3,54,198,6,135,6,1,195,138,194,187,117,6,54,138,23,182,
  0,168,10,116,58,168,2,116,27,128,250,15,117,12,54,198,7,0,54,199,6,2,24,32,88,195,54,254,7,54,128,6,
  3,24,8,195,128,250,0,117,12,54,198,7,15,54,199,6,2,24,32,208,195,54,254,15,54,128,46,3,24,8,195,168,
  64,116,18,187,80,6,3,218,54,138,7,254,192,60,45,114,22,176,0,235,18,168,128,116,30,187,80,6,3,218,54,138,
  7,44,1,115,2,176,44,54,136,7,191,22,17,3,250,3,250,232,22,254,54,136,5,195,187,116,6,54,138,23,168,1,
  116,7,10,210,116,115,74,235,8,54,58,22,134,6,115,105,66,182,0,82,54,138,23,176,4,232,185,254,90,176,5,232,
  179,254,54,136,23,54,198,6,117,6,0,54,198,6,118,6,0,190,183,17,54,128,62,133,6,1,117,3,190,199,17,3,
  242,3,242,46,139,4,54,163,26,24,128,196,8,187,2,24,185,6,0,128,250,0,116,33,54,128,62,133,6,1,116,14,
  128,250,2,119,9,73,54,137,7,131,195,4,51,192,54,137,7,131,195,4,128,196,8,226,245,190,128,6,54,199,4,0,
  0,54,199,68,2,136,8,54,138,30,134,6,54,56,30,116,6,117,11,54,199,4,0,0,54,199,68,2,255,15,54,139,
  28,54,137,30,128,254,54,139,92,2,54,137,30,130,254,195,138,194,187,118,6,54,138,23,182,0,168,10,116,58,168,2,
  116,27,128,250,3,117,12,54,198,7,0,54,199,6,2,24,56,88,195,54,254,7,54,128,6,3,24,8,195,128,250,0,
  117,12,54,198,7,3,54,199,6,2,24,56,112,195,54,254,15,54,128,46,3,24,8,195,168,192,116,87,187,214,17,190,
  16,6,128,250,2,114,4,70,187,218,17,168,64,54,138,4,116,30,246,194,1,117,10,4,16,60,160,114,48,36,15,235,
  44,64,138,224,36,15,60,10,138,196,114,33,36,240,235,29,246,194,1,117,14,168,240,116,4,44,16,235,16,36,15,12,
  144,235,10,168,15,117,5,36,240,12,9,64,72,54,136,4,232,99,253,195,82,246,194,202,116,53,187,18,6,54,138,7,
  246,194,66,116,15,64,60,10,117,2,176,16,60,19,114,22,176,1,235,18,10,192,117,1,64,72,60,15,117,2,176,9,
  10,192,117,2,176,18,54,136,7,187,22,18,232,39,253,90,195,82,246,194,202,116,77,187,19,6,54,138,7,246,194,66,
  116,27,64,60,10,117,2,176,16,60,26,117,2,176,32,60,42,117,2,176,48,60,50,114,34,176,1,235,30,10,192,117,
  1,64,72,60,15,117,2,176,9,60,31,117,2,176,25,60,47,117,2,176,41,10,192,117,2,176,49,54,136,7,187,86,
  18,232,210,252,90,195,82,246,194,202,116,48,187,20,6,54,138,7,180,0,246,194,136,116,8,72,121,13,184,2,0,235,
  8,254,192,60,3,114,2,176,0,54,136,7,192,224,3,180,0,190,203,18,3,240,191,214,18,232,10,252,90,195,82,246,
  194,202,116,45,187,21,6,54,138,7,180,0,246,194,136,116,8,72,121,12,184,4,0,235,7,64,60,5,114,2,176,0,
  54,136,7,192,224,2,190,227,18,3,240,191,86,19,232,213,251,90,195,246,194,202,116,55,187,35,6,54,138,7,138,240,
  128,230,192,37,3,0,246,194,136,116,8,254,200,121,12,176,3,235,8,254,192,60,4,114,2,176,0,10,240,54,136,55,
  230,158,208,224,190,247,18,3,240,191,214,17,232,151,251,195,246,194,202,116,70,187,35,6,54,138,7,138,240,128,230,131,
  37,64,0,192,232,6,246,194,136,116,8,254,200,121,12,176,1,235,8,254,192,60,2,114,2,176,0,80,80,192,224,6,
  10,240,54,136,55,88,208,224,12,1,230,20,88,192,224,3,190,255,18,3,240,191,150,18,232,75,251,195,190,80,6,191,
  0,6,185,16,0,54,138,4,232,31,251,54,136,5,71,70,226,243,190,0,6,191,48,6,185,11,0,54,139,4,54,139,
  21,70,70,71,71,59,194,117,3,226,240,195,187,29,6,54,254,7,117,3,54,254,15,195,187,114,6,54,160,96,6,54,
  58,6,100,6,117,36,36,202,116,32,54,128,63,37,114,22,187,115,6,54,254,7,54,128,63,15,114,18,54,198,7,0,
  54,8,6,98,6,195,54,254,7,195,54,198,7,0,195,96,183,0,54,138,30,132,6,83,54,139,46,133,6,129,229,15,
  0,209,229,46,139,190,59,18,3,251,46,138,53,46,139,190,63,18,3,251,3,251,46,139,53,128,251,2,119,13,208,235,
  54,138,143,117,6,181,0,209,225,3,241,191,0,24,185,6,0,54,128,62,119,6,1,116,41,58,206,116,37,54,138,20,
  131,253,2,116,11,128,251,1,119,6,132,210,117,2,178,45,54,136,21,71,54,198,5,41,70,70,131,199,3,226,218,91,
  235,43,54,198,5,0,71,54,198,5,41,131,199,3,226,242,91,128,251,1,117,23,54,255,54,2,24,54,143,6,22,24,
  54,131,6,22,24,8,54,199,6,20,24,43,45,97,195,54,128,62,136,6,1,116,10,187,207,20,185,18,0,232,25,0,
  195,54,139,46,133,6,129,229,15,0,193,229,3,187,243,20,3,221,185,3,0,232,1,0,195,191,0,8,46,139,55,81,
  177,28,46,139,20,54,137,21,70,70,71,71,226,244,131,199,8,67,67,89,226,230,195,96,30,54,128,62,133,6,0,117,
  79,54,128,62,116,6,1,117,71,182,0,54,138,22,36,6,54,160,99,6,168,2,116,9,254,194,128,250,15,117,2,178,
  0,168,8,116,9,254,202,128,250,255,117,2,178,14,168,1,116,10,178,0,104,0,6,31,138,22,32,0,190,147,14,3,
  242,3,242,46,255,52,54,143,6,130,255,54,137,22,36,6,31,97,195,0,0,0,15,112,15,240,15,240,7,240,0,247,
  0,255,0,127,0,15,0,15,7,15,15,7,15,255,15,119,7,96,30,51,192,230,136,230,137,230,138,230,139,230,144,230,
  145,191,160,6,185,8,0,243,171,54,128,62,152,6,1,117,26,14,31,190,81,22,179,1,54,136,30,176,6,54,140,14,
  178,6,54,199,6,180,6,97,22,235,66,104,0,6,31,51,219,139,235,139,251,185,4,0,131,191,36,0,255,116,6,254,
  195,254,195,226,243,208,235,54,136,30,176,6,139,54,34,0,54,199,6,178,6,0,6,138,203,54,198,133,160,6,1,62,
  139,150,36,0,137,150,180,6,71,69,69,226,236,176,8,246,227,139,200,191,0,4,243,165,176,16,230,143,138,195,60,4,
  117,4,176,6,235,2,208,224,12,9,230,145,138,203,176,255,210,224,246,208,230,144,31,97,195,96,30,54,142,30,178,6,
  51,219,51,237,181,0,54,138,14,176,6,128,190,172,6,0,117,94,128,190,160,6,0,116,77,139,253,209,231,54,139,181,
  164,6,54,139,157,180,6,139,64,2,186,136,0,3,213,238,136,166,172,6,54,131,133,164,6,4,139,0,186,128,0,3,
  215,239,169,0,128,116,41,54,128,62,152,6,1,116,7,198,134,160,6,0,235,7,54,199,133,164,6,0,0,128,190,172,
  6,0,116,16,235,10,176,0,186,136,0,3,213,238,235,4,254,142,172,6,69,226,148,31,97,195,96,30,104,0,6,31,
  139,22,7,0,187,151,6,191,152,6,54,128,61,1,117,8,54,198,6,112,6,1,235,68,54,254,7,54,56,23,119,8,
  114,58,176,5,230,0,235,52,54,128,62,176,6,0,116,3,232,70,255,228,2,60,146,117,250,232,55,244,255,30,24,0,
  54,160,120,6,54,56,7,117,4,176,0,230,21,54,56,55,117,10,176,0,230,0,54,198,6,153,6,1,176,64,230,182,
  31,97,207,189,1,189,3,0,0,0,0,0,0,0,0,62,99,103,107,115,99,62,0,60,12,12,12,12,12,12,0,126,
  3,3,62,96,96,127,0,126,3,3,62,3,3,126,0,30,54,102,102,102,127,6,0,127,96,96,126,3,3,126,0,62,
  96,96,126,99,99,62,0,127,99,6,12,24,24,24,0,62,99,99,62,99,99,62,0,62,99,99,63,3,3,62,0,28,
  54,99,99,127,99,99,0,126,99,99,126,99,99,126,0,62,99,96,96,96,99,62,0,124,102,99,99,99,102,124,0,127,
  96,96,126,96,96,127,0,127,96,96,126,96,96,96,0,63,96,96,103,99,99,62,0,99,99,99,127,99,99,99,0,60,
  24,24,24,24,24,60,0,15,3,3,99,99,99,62,0,99,102,108,120,108,102,99,0,96,96,96,96,96,96,127,0,99,
  119,127,107,99,99,99,0,99,115,123,111,103,99,99,0,62,99,99,99,99,99,62,0,126,99,99,126,96,96,96,0,62,
  99,99,107,111,103,62,0,126,99,99,126,108,102,99,0,62,99,96,62,3,99,62,0,126,24,24,24,24,24,24,0,99,
  99,99,99,99,99,62,0,99,99,99,54,54,28,8,0,99,107,107,107,127,54,34,0,99,99,54,28,54,99,99,0,102,
  102,102,60,24,24,24,0,127,3,6,12,24,48,127,0,34,119,127,127,62,28,8,0,24,28,22,18,18,112,96,0,8,
  8,8,127,8,8,8,0,0,0,0,127,0,0,0,0,60,102,102,12,24,0,24,0,0,0,0,0,0,96,96,0,127,
  0,0,0,0,0,0,0,16,24,28,30,28,24,16,0,127,127,127,127,127,127,127,0,8,8,32,80,56,80,64,80,72,
  80,88,80,104,80,120,80,8,160,56,80,80,80,120,80,68,16,106,16,12,17,132,17,204,17,10,18,78,18,206,18,66,
  19,214,19,86,17,214,18,86,19,68,16,106,16,200,17,132,18,214,17,150,18,214,19,103,18,117,18,124,18,129,18,138,
  18,143,18,149,18,153,18,157,18,183,18,186,18,203,18,227,18,103,18,117,18,167,18,174,18,247,18,255,18,183,18,128,
  19,0,17,192,17,0,18,64,18,192,18,64,19,192,19,64,17,128,17,128,19,192,17,128,18,192,19,67,18,75,18,79,
  18,95,18,6,5,5,3,3,0,3,4,6,5,2,4,0,0,22,17,214,17,22,18,86,18,214,18,86,19,214,19,0,
  0,214,17,150,18,214,19,26,15,28,29,25,24,11,22,0,14,11,30,11,255,25,26,30,19,25,24,255,24,11,23,15,
  255,12,19,28,30,18,14,11,35,255,35,15,11,28,255,23,25,24,30,18,255,14,11,35,255,29,15,34,255,12,22,25,
  25,14,30,35,26,15,255,32,25,22,31,23,15,255,13,25,24,30,28,11,29,30,255,25,21,255,43,43,43,43,43,43,
  43,43,43,43,43,43,43,43,43,43,255,41,0,0,0,0,0,255,0,23,11,22,15,0,0,255,0,16,15,23,11,22,
  15,255,0,41,0,255,0,11,0,255,0,12,0,255,0,25,0,255,0,11,12,255,0,1,255,2,255,3,255,4,255,22,
  25,33,0,255,0,0,0,18,19,17,18,255,0,0,0,1,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,
  32,2,32,2,32,2,32,2,32,2,32,2,32,6,32,7,32,0,32,0,32,11,32,18,32,18,32,18,32,18,32,18,
  32,18,32,18,32,13,32,5,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,
  32,0,32,0,32,8,32,9,32,0,32,0,32,12,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,14,32,3,
  32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,
  32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,15,32,5,32,0,32,0,32,0,32,0,
  32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,
  32,0,32,0,32,0,32,0,32,0,32,0,32,5,96,1,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,
  160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,160,2,
  160,2,160,2,160,1,224,13,96,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,32,18,
  32,18,32,18,32,18,32,19,32,0,32,0,32,16,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,1,96,14,
  96,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,20,32,0,
  32,0,32,0,32,17,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,5,96,15,96,4,32,4,32,4,32,4,
  32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,
  32,4,32,4,32,4,32,4,32,4,32,4,32,3,96,15,19,71,19,127,19,183,19,183,19,183,19,183,19,183,19,183,
  19,183,19,183,19,183,19,183,19,183,19,183,19,183,19,183,19,239,19,15,19,71,19,127,19,0,0,39,20,95,20,151,
  20,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,252,252,248,249,240,243,
  225,255,255,255,255,255,255,0,0,0,0,0,0,255,0,255,255,231,227,230,228,236,232,249,240,243,225,231,227,231,227,231,
  227,255,255,0,0,0,0,255,0,255,255,255,255,255,255,255,255,231,227,231,227,231,227,231,227,231,227,231,227,231,227,231,
  227,255,255,255,255,255,255,0,0,0,0,0,0,255,0,255,254,255,255,255,255,255,255,31,15,15,15,15,15,31,15,63,
  31,254,254,252,252,249,248,249,241,255,255,249,241,255,255,249,241,127,63,255,127,255,255,255,255,255,255,255,255,255,255,255,
  255,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,255,255,255,255,255,255,240,255,240,255,240,255,240,255,
  224,255,192,255,128,255,0,255,0,255,224,255,0,255,224,255,0,255,255,255,255,255,255,255,255,255,127,255,63,255,31,255,
  15,255,7,255,7,255,7,255,7,255,7,255,7,255,7,255,7,255,199,127,39,63,23,159,15,207,135,231,199,231,199,231,
  199,255,255,255,255,255,255,248,240,248,240,248,240,243,240,231,227,207,199,159,143,63,31,63,31,255,255,63,31,255,255,63,
  31,255,255,255,255,255,255,255,0,255,0,255,0,255,0,255,0,255,255,255,255,255,255,255,15,255,15,255,15,255,31,255,
  63,255,0,255,0,255,1,255,1,255,15,255,1,255,15,255,1,168,220,238,239,222,188,154,137,103,86,52,18,16,17,50,
  118,185,6,136,10,185,6,68,10,38,7,136,10,38,7,68,10,25,7,136,10,25,7,68,10,38,7,136,10,38,7,68,
  10,62,7,136,10,62,7,68,10,38,7,136,10,38,7,68,10,25,7,136,10,25,7,68,10,38,7,136,10,38,7,68,
  10,0,0,0,20,38,7,136,10,38,7,68,10,25,7,136,10,25,7,68,10,38,7,136,10,38,7,68,10,62,7,136,
  10,62,7,68,10,38,7,136,10,38,7,68,10,25,7,136,10,25,7,68,10,38,7,136,10,38,7,68,10,145,6,136,
  10,145,6,68,10,11,7,136,10,11,7,68,10,253,6,136,10,253,6,68,10,11,7,136,10,11,7,68,10,38,7,136,
  10,38,7,68,10,11,7,136,10,11,7,68,10,253,6,136,10,253,6,68,10,11,7,136,10,11,7,68,10,0,0,0,
  20,11,7,136,10,11,7,68,10,253,6,136,10,253,6,68,10,11,7,136,10,11,7,68,10,38,7,136,10,38,7,68,
  10,11,7,136,10,11,7,68,10,253,6,136,10,253,6,68,10,11,7,136,10,11,135,68,10,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,3,0,0,1,32,244,24,16,18,42,0,106,0,250,0,22,9,164,9,6,6,66,1,0,6,96,108,68,80,
  0,0,42,6,74,6,86,6,255,255,0,0,255,15,255,15,255,15,255,15,255,15,255,15,255,15,255,15,0,0,255,15,
  255,15,255,15,255,15,255,15,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,15,0,0,255,15,
  0,0,255,15,0,0,255,15,255,15,15,63,127,127,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,224,224,
  224,231,0,192,224,224,240,112,224,224,231,231,224,224,224,255,255,255,192,224,240,112,240,240,224,192,0,15,15,15,29,29,
  29,56,0,128,128,128,192,192,192,224,56,56,112,112,112,255,255,255,224,224,112,112,112,56,56,56,0,240,240,248,248,252,
  252,254,0,224,224,224,224,224,224,224,238,239,231,231,227,227,225,225,224,224,224,224,224,224,224,224,0,255,255,255,224,224,
  224,224,0,192,224,224,240,112,112,112,224,224,224,224,224,255,255,255,112,112,112,112,240,224,224,192,46,8,47,8,47,8,
  47,8,47,8,46,72,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,
  47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,47,8,46,136,47,8,47,8,47,8,47,8,
  46,200,96,54,128,62,1,112,0,117,80,51,192,54,163,130,255,54,160,0,112,192,224,2,189,31,5,3,232,46,139,118,
  0,69,69,46,139,94,0,191,64,24,185,6,0,81,46,139,23,177,2,81,177,2,46,139,4,54,137,5,71,71,70,70,
  54,137,21,71,71,128,198,8,226,236,128,238,16,131,194,8,89,226,224,67,67,89,226,213,233,39,3,182,0,54,138,22,
  2,112,187,159,5,3,218,46,138,7,54,56,6,1,112,116,3,233,14,3,187,206,5,208,226,3,218,255,39,54,199,6,
  2,255,240,0,54,254,6,2,112,233,246,2,54,199,6,2,255,0,0,54,199,6,34,255,240,15,54,254,6,2,112,233,
  224,2,54,199,6,34,255,0,0,54,199,6,66,255,255,0,54,254,6,2,112,233,202,2,54,199,6,66,255,0,0,54,
  199,6,98,255,0,15,54,254,6,2,112,233,180,2,54,199,6,98,255,0,0,54,199,6,162,255,15,0,54,254,6,2,
  112,233,158,2,54,199,6,162,255,0,0,54,199,6,194,255,15,15,54,254,6,2,112,233,136,2,54,199,6,194,255,0,
  0,54,254,6,2,112,233,121,2,184,0,1,186,17,1,232,119,2,54,254,6,2,112,233,104,2,184,0,2,186,34,2,
  232,102,2,54,254,6,2,112,233,87,2,184,0,3,186,51,3,232,85,2,54,254,6,2,112,233,70,2,184,0,4,186,
  68,4,232,68,2,54,254,6,2,112,233,53,2,184,0,5,186,85,5,232,51,2,54,254,6,2,112,233,36,2,184,0,
  6,186,102,6,232,34,2,54,254,6,2,112,233,19,2,184,0,7,186,119,7,232,17,2,54,254,6,2,112,233,2,2,
  184,0,8,186,136,8,232,0,2,54,254,6,2,112,233,241,1,184,0,9,186,153,9,232,239,1,54,254,6,2,112,233,
  224,1,184,0,10,186,170,10,232,222,1,54,254,6,2,112,233,207,1,184,0,11,186,187,11,232,205,1,54,254,6,2,
  112,233,190,1,184,0,12,186,204,12,232,188,1,54,254,6,2,112,233,173,1,184,0,13,186,221,13,232,171,1,54,254,
  6,2,112,233,156,1,184,0,14,186,238,14,232,154,1,54,254,6,2,112,233,139,1,184,0,15,186,255,15,232,137,1,
  54,139,22,36,6,191,230,6,3,250,3,250,46,255,53,54,143,6,130,255,54,254,6,2,112,233,102,1,54,199,6,0,
  254,17,1,233,87,1,54,199,6,0,254,34,2,54,198,6,65,24,10,54,198,6,69,24,10,54,198,6,73,24,10,54,
  198,6,77,24,10,233,53,1,54,199,6,0,254,51,3,54,139,22,36,6,191,230,6,3,250,3,250,46,255,53,90,187,
  15,240,42,222,208,235,2,243,138,194,36,240,42,248,208,239,128,231,240,2,199,179,15,128,226,15,42,218,208,235,2,211,
  10,208,54,137,22,194,255,54,198,6,1,24,12,233,237,0,54,198,6,1,24,14,54,198,6,5,24,12,233,222,0,54,
  199,6,0,254,68,4,54,198,6,1,24,12,54,198,6,5,24,14,54,198,6,9,24,12,233,194,0,232,254,0,233,188,
  0,54,199,6,0,254,85,5,232,241,0,233,175,0,232,235,0,233,169,0,54,199,6,0,254,102,6,232,222,0,233,156,
  0,232,216,0,233,150,0,54,199,6,0,254,119,7,232,203,0,233,137,0,232,197,0,233,131,0,54,199,6,0,254,136,
  8,232,184,0,235,119,232,179,0,235,114,54,199,6,0,254,153,9,232,167,0,235,102,232,162,0,235,97,54,199,6,0,
  254,170,10,232,150,0,235,85,54,198,6,53,24,8,54,198,6,57,24,12,54,198,6,61,24,14,235,65,54,199,6,0,
  254,187,11,54,198,6,57,24,8,54,198,6,61,24,12,235,44,54,198,6,61,24,8,235,36,54,199,6,0,254,204,12,
  235,27,54,199,6,0,254,221,13,235,18,54,199,6,0,254,238,14,235,9,54,199,6,0,254,255,15,235,5,54,254,6,
  2,112,54,254,6,1,112,97,203,54,163,130,254,54,163,0,255,54,137,22,2,255,54,163,32,255,54,137,22,34,255,54,
  163,64,255,54,137,22,66,255,54,163,96,255,54,137,22,98,255,54,137,22,162,255,54,137,22,194,255,195,187,1,24,54,
  2,30,3,112,54,198,71,4,8,54,198,71,8,12,54,198,71,12,14,54,198,71,16,12,54,128,6,3,112,4,195,39,
  5,135,5,87,5,147,5,57,12,0,12,59,12,0,12,52,10,53,10,54,10,55,10,60,6,61,6,62,6,63,6,56,
  4,57,4,58,4,59,4,52,2,53,2,54,2,55,2,48,0,49,0,50,0,51,0,59,12,57,12,0,12,0,12,54,
  10,52,10,55,10,53,10,62,6,60,6,63,6,61,6,58,4,56,4,59,4,57,4,54,2,52,2,55,2,53,2,50,
  0,48,0,51,0,49,0,56,120,56,106,56,93,40,120,40,106,40,93,80,112,66,112,53,112,80,128,66,128,53,128,8,
  16,24,32,40,48,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,
  83,84,85,86,87,88,89,90,91,92,93,94,95,96,189,1,204,1,226,1,248,1,14,2,36,2,58,2,73,2,90,2,
  107,2,124,2,141,2,158,2,175,2,192,2,209,2,226,2,243,2,4,3,21,3,38,3,55,3,92,3,102,3,136,3,
  208,3,223,3,251,3,1,4,14,4,20,4,33,4,39,4,52,4,58,4,70,4,75,4,87,4,92,4,104,4,124,4,
  145,4,153,4,162,4,171,4,180,4,255,238,221,204,187,170,153,136,119,102,85,68,51,34,17,0,255,238,221,204,187,170,
  153,136,119,102,85,68,51,34,17,0,147,7,240,1,153,7,240,1,159,7,240,1,164,7,240,1,169,7,240,1,174,7,
  240,1,179,7,240,1,183,7,240,1,187,7,240,1,191,7,225,1,195,7,225,1,198,7,225,1,201,7,210,1,205,7,
  195,1,207,7,180,1,210,7,165,1,213,7,150,1,215,7,135,1,217,7,120,1,220,7,105,1,222,7,90,1,224,7,
  75,1,225,7,60,1,227,7,45,1,229,7,30,1,230,7,15,1,230,7,15,1,230,7,14,3,230,7,13,3,230,7,
  12,3,230,7,11,3,230,7,10,3,230,7,9,3,230,7,8,3,230,7,7,3,230,7,6,3,230,7,5,3,230,7,
  4,3,230,135,3,3,0,0,0,15,112,15,240,15,240,7,240,0,247,0,255,0,127,0,15,0,15,7,15,15,7,15,
  255,15,119,7,0,0,0,0,0,0,0,0,0,0,0,0,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,
  66,111,111,116,32,82,111,109,32,83,116,97,102,102,32,32,80,114,111,103,114,97,109,101,114,32,32,32,32,32,32,32,
  32,75,111,117,115,101,105,32,75,97,122,101,116,111,32,32,83,111,117,110,100,32,67,111,109,112,111,115,101,114,32,32,
  32,84,97,107,97,115,104,105,32,73,115,111,121,97,109,97,71,114,97,112,104,105,99,32,68,101,115,105,103,110,101,114,
  32,89,117,107,97,114,105,32,72,111,110,100,97,32,32,32,83,112,101,99,105,97,108,32,84,104,97,110,107,115,32,32,
  32,77,97,115,97,32,84,111,114,105,105,32,32,32,32,32,32,83,97,116,111,114,117,32,73,109,97,105,32,32,32,32,
  32,75,97,119,97,66,117,116,116,101,114,32,32,32,32,32,32,77,97,115,97,104,105,114,111,73,119,97,109,111,116,111,
  43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,234,0,0,0,254,0,0,0,0,0,0,0,0,0,0,0,
};
}
}
